//-+-------------------------------------------------------------------------+-
//        world.h:   Classes declarations                                      
//                                                                             
//-+-------------------------------------------------------------------------+-
#include <VSDL.h>
#include <SDL_net.h>
#include "net.h"
#include "ball.h"
#include "raket.h"

#define WORLD_STATE_SERVICE 1
#define WORLD_STATE_PLAY    2
#define WORLD_STATE_PAUSE   3
#define WORLD_STATE_FINISH  4
#define WORLD_STATE_MESSAGE 5

#define WORLD_NET_NONE      0
#define WORLD_NET_SERVER    1
#define WORLD_NET_CLIENT    2

/* sound effects */
#define SFX_WOOD  0
#define SFX_IRON  1
#define SFX_CRASH 2
#define NB_SFX    3

/* math */
#define PI           3.141592

class World
{
 public:
   World() ;
   ~World() ;
   int InitServer() ;
   int Connect( char* host) ;
   void CloseNet() ;
   int MovePlayer( int Player, int direction) ;
   int Update() ;
   int NetProcessEvents() ;
   int Export( int noPl, Uint32 host, Uint16 port) ;
   int Import( ) ;
   void AutoPlay() ;
   int maskComputerPlayers ;
 protected:
   Raquette* R[4] ;
   Ball* B ;
   int DetectCollisions() ;
   int nbPlayers ;
   int noPlayer ;
   //int maskComputerPlayers ;
   int state ;
   int service ;
   int score[4] ; 
   int sfx[NB_SFX] ;
   int netStatus ;
   UDPsocket socket ;
   UDPpacket** packets ;
   IPaddress serverIP ;
} ;
