//-+-------------------------------------------------------------------------+-
//    world.cc: classes definition               
//-+-------------------------------------------------------------------------+-
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <iostream.h>
#include <fstream.h>
#include "def.h"
#include "net.h"
#include "world.h"

//-+---------- World Constructor --------------------------------------------+-
World::World() {
   int i ;
   
   netStatus = WORLD_NET_NONE ;
   nbPlayers = 2 ;
   maskComputerPlayers = 2 ;
   noPlayer = 1 ;
   service = 1 ;
   
   if ( nbPlayers == 2 ) {
      R[1] = new Raquette(-TABLE_WIDTH/2,TABLE_WIDTH/2,-TABLE_LONG/2,-TABLE_LONG/2+RK_ZMOVE ) ;
      R[2] = new Raquette(-TABLE_WIDTH/2,TABLE_WIDTH/2,+TABLE_LONG/2-RK_ZMOVE,+TABLE_LONG/2) ;
   } else if ( nbPlayers == 4 ) {
      R[1] = new Raquette(-TABLE_WIDTH/2,TABLE_WIDTH/2,
			  -TABLE_LONG/2+RK_ZMOVE/2,-TABLE_LONG/2+RK_ZMOVE) ;
      R[2] = new Raquette(-TABLE_WIDTH/2,TABLE_WIDTH/2,
			  -TABLE_LONG/2,-TABLE_LONG/2+RK_ZMOVE/2) ;
      R[3] = new Raquette(-TABLE_WIDTH/2,TABLE_WIDTH/2,
			  +TABLE_LONG/2-RK_ZMOVE,+TABLE_LONG/2-RK_ZMOVE/2) ;
      R[4] = new Raquette(-TABLE_WIDTH/2,TABLE_WIDTH/2,
			  +TABLE_LONG/2-RK_ZMOVE/2,+TABLE_LONG/2) ;
   }
   
   B = new Ball(0,-TABLE_LONG/2+60) ;
   
   for(i=1;i<=nbPlayers;i++) {
      score[i] = 0 ;
   }
   
   for(i=0;i<NB_SFX;i++)
     sfx[i] = 0 ;
   
   state = WORLD_STATE_SERVICE ;
   netStatus = WORLD_NET_NONE ; 
   packets = NULL ;
   socket = NULL ;
}

World::~World() {
   
   delete R[1] ;
   delete R[2] ;
   delete B ;
}

int World::InitServer() {
   
   if ( netStatus == WORLD_NET_NONE) {
      
      netStatus = WORLD_NET_SERVER ;
      packets = SDLNet_AllocPacketV( 10, sizeof( REQUEST)) ;
      if ( packets == NULL ) {
	 fprintf( stderr, "Couldn't allocate packets: Out of memory.\n") ;
	 return( 1) ;
      }
      socket = SDLNet_UDP_Open( SERVER_PORT) ;
   }
   return( 0) ;
}
 
int World::Connect( char* host) {
   int i ;
   
   if ( netStatus == WORLD_NET_NONE ) {
      
      packets = SDLNet_AllocPacketV( 10, sizeof( REQUEST)) ;
      if ( packets == NULL ) {
	 fprintf( stderr, "Couldn't allocate packets: Out of memory.\n") ;
	 return( 1) ;
      }
      printf("Try to connect to %s...\n", host) ;
      netStatus = WORLD_NET_CLIENT ;
      SDLNet_ResolveHost( &serverIP, host, SERVER_PORT) ;
      if ( serverIP.host == INADDR_NONE ) {
	 fprintf( stderr, "Couldn't resolve hostname: %s\n", host) ; 
	 return( 2) ;
      }
      
      for(i=0;i<10&socket==NULL;i++)
	socket =  SDLNet_UDP_Open( CLIENT_PORT) ;
      
      if ( socket == NULL ) {
	 fprintf( stderr, "There is no free UDP endpoint.\n") ;
	 return( 3) ;
      }
      if ( SDLNet_UDP_Bind( socket, -1, &serverIP) == -1 ) {
	 fprintf( stderr, "Cannot bind the server.\n") ;
	 return( 4) ;
      }
   }
   return( 0) ;
}

void World::CloseNet() {
   
   if ( netStatus == WORLD_NET_CLIENT) {
      // send deconnection....
      SDLNet_UDP_Close( socket) ;
      netStatus = WORLD_NET_NONE ;
   }
   else if ( netStatus == WORLD_NET_SERVER ) {
      // send deconnection....
      SDLNet_UDP_Close( socket) ;
      netStatus = WORLD_NET_NONE ;
   }
   
}

//-+---------- Moving the Players -------------------------------------------+-
int World::MovePlayer( int Player, int action ) {
   REQUEST req ;
   int i ;
   unsigned char translatedAction ;
   
   if ( netStatus != WORLD_NET_CLIENT) {
      
      if ( Player <= 0 && Player > nbPlayers )
	return( 0) ;
      
      for(i=0;i<4;i++) {
	 R[Player]->Go( action) ; 
	 DetectCollisions() ;
      }
   } 
   else { /* netStatus == WORLD_NET_CLIENT */
      translatedAction = 0 ;
      if ( action & DIR_LEFT )
	translatedAction |= DIR_RIGHT ;
      if ( action & DIR_RIGHT )
	translatedAction |= DIR_LEFT ;
      if ( action & DIR_UP )
	translatedAction |= DIR_DOWN ;
      if ( action & DIR_DOWN )
	translatedAction |= DIR_UP ;
	  
      req.player.type = PLAYER_MOVE ;
      req.player.action = translatedAction ; 
      memcpy( packets[0]->data, &req.player, sizeof( req.player)) ;
      packets[0]->len = sizeof( req.player) ;
      memcpy( &packets[0]->address, &serverIP, sizeof( serverIP)) ;
      if ( SDLNet_UDP_Send( socket, -1, packets[0]) == -1 )
	return( 1) ;      
   }
   return( 0) ;
}

//-+---------- Detect the collisions ----------------------------------------+-
int World::DetectCollisions() {
   int decX, decZ ;
   int i ;
   
   /* Collision between B and the borders */
   if ( B->posX > TABLE_WIDTH/2 ) {
      B->posX = TABLE_WIDTH/2 ;
      B->Rebondir( CHORIZ, -1, -1) ;
      sfx[SFX_WOOD] = 1 ;
   }
   if ( B->posX < -TABLE_WIDTH/2  ) {
      B->posX = -TABLE_WIDTH/2 ;
      B->Rebondir( CHORIZ, -1, -1) ;
      sfx[SFX_WOOD] = 1 ;
   }
   
   /* Collision between R and the ball */
   for(i=1;i<=nbPlayers;i++) {
      decX = (int)B->posX - R[i]->posX ;
      decZ = (int)B->posZ - R[i]->posZ ;
      if ( ( abs(decX) <= RK_WIDTH/2 ) && ( abs(decZ) <= RK_DEEP/2 ) ) {
	 B->Rebondir(CVERT, atan2((float)decZ+R[i]->ey,
				  (float)decX+R[1]->ex*2.5), 
		     (int)R[i]->power) ;
	 /* move the gravity center on effect */
	 sfx[SFX_IRON] = 1 ;
	 if ( state == WORLD_STATE_SERVICE )
	   state = WORLD_STATE_PLAY ; 
      }
   }
   return( 1) ;
}

//-+---------- Moving the World ---------------------------------------------+-
int World::Update() {
   int i ;
   
   if ( netStatus != WORLD_NET_CLIENT ) {
      AutoPlay() ;
      for(i=0;i<B->power;i++) {
	 B->Go() ;
	 DetectCollisions() ;
	 
	 /* Collision with the borders */
	 int winer = 0 ;
	 if( B->posZ < -TABLE_LONG/2 )
	   winer = 2 ; /* player 2 win */
	 else if( B->posZ > +TABLE_LONG/2 )
	   winer = 1 ; /* player 1 win */
	 if ( winer != 0 ) {
	    score[winer]++ ;
	    delete B ;
	    if ( score[winer] > 4 ) {
	       state = WORLD_STATE_FINISH ;
	       score[1] = 0 ;
	       score[2] = 0 ;
	       return( winer) ;
	    }
	    if ( service == 1 ) {
	       service = 2 ;
	       B = new Ball( 0, TABLE_LONG/2-60) ;
	       service = 2 ;
	    } else { 
	       service = 1 ;
	       B = new Ball( 0, -TABLE_LONG/2+60) ;
	       service = 1 ;
	    }
	    sfx[SFX_CRASH] = 1 ;
	    state = WORLD_STATE_SERVICE ;
	 }
      }
   }
   else { /* netStatus == WORLD_NET_CLIENT */
      Import() ;
   }
   return( 0) ;
}

void World::AutoPlay() {
   int i ;
   
   for(i=1;i<=nbPlayers;i++)
     if ( (1<<(i-1)) & maskComputerPlayers) {
	if ( state == WORLD_STATE_SERVICE && service == i )
	  MovePlayer( i, DIR_DOWN) ;
	
	if ( B->posX - R[i]->posX > 0 )
	  MovePlayer( i, DIR_RIGHT ) ;
	else
	  MovePlayer( i, DIR_LEFT ) ;
     }
}

int World::NetProcessEvents() {
   REQUEST req ;
   int n, i ;
   
   n = SDLNet_UDP_RecvV( socket, packets) ;
   //printf("SERVER RECEIVED %d PACKETS...\n", n) ;
   for(i=0;i<n;i++) {
      memcpy( &req, packets[i]->data, sizeof(req)) ;
      if ( req.type == PLAYER_MOVE ) {
	 MovePlayer( 2, req.player.action) ;
      }
      else if ( req.type == GIVE_WALLET ) {
	 Export( 2, packets[i]->address.host, packets[i]->address.port) ;
      }
   }
   return( 0) ;
}

//-+---------- Export the World ---------------------------------------------+-
int World::Export( int noPl, Uint32 host, Uint16 port) {
   REQUEST req ;
   int i ;
   
   req.wallet.nbPlayers = nbPlayers ;
   req.wallet.noPlayer = noPl ;
   req.wallet.service = service ;
   for(i=1;i<=2;i++) {
      req.wallet.score[i] = score[i] ;
      req.wallet.RposX[i] = R[i]->posX ;
      req.wallet.RposY[i] = R[i]->posY ;
      req.wallet.RposZ[i] = R[i]->posZ ;
   }
   req.wallet.BposX = B->posX ;
   req.wallet.BposY = B->posY ;
   req.wallet.BposZ = B->posZ ;
   for(i=0;i<NB_SFX;i++)
     req.wallet.sfx[i] = sfx[i] ;
   /* send the wallet to client */
   
   req.wallet.type = THIS_IS_THE_WALLET ;
   memcpy( packets[0]->data, &req.wallet, sizeof( req.wallet)) ;
   packets[0]->len = sizeof( req.wallet) ;
   packets[0]->address.host = host ;
   packets[0]->address.port = port ;
   if ( SDLNet_UDP_Send( socket, -1, packets[0]) != 1 ) {
      return( 1) ;
   }
   else{
      return( 0) ;
   }
}

//-+---------- Import the World ---------------------------------------------+-
int World::Import( ) {
   REQUEST req ;
   int n, i, j ;
   
   /* request the server for a wallet */
   req.type = GIVE_WALLET ;
   memcpy( packets[0]->data, &req.type, sizeof( req.type)) ;
   packets[0]->len = sizeof( req.type) ;
   SDLNet_UDP_Send( socket, 0, packets[0]) ;
   /* then read the wallet */
   n = SDLNet_UDP_RecvV( socket, packets) ;
   for(i=0;i<n;i++) {
      memcpy( &req, packets[i]->data, sizeof(req)) ;
      if ( req.type == THIS_IS_THE_WALLET )  {
	 nbPlayers = req.wallet.nbPlayers ;
	 noPlayer = req.wallet.noPlayer ;
	 service = req.wallet.service ;
	 for(j=1;j<=nbPlayers;j++) {
	    score[j] = req.wallet.score[j] ;
	    R[j]->posX = req.wallet.RposX[j] ;
	    R[j]->posY = req.wallet.RposY[j] ;
	    R[j]->posZ = req.wallet.RposZ[j] ;
	 }
	 B->posX = (float)req.wallet.BposX ;
	 B->posY = (float)req.wallet.BposY ;
	 B->posZ = (float)req.wallet.BposZ ;   
	 for(j=0;j<NB_SFX;j++)
	   sfx[j] = req.wallet.sfx[i] ;  
      }
   }
   return( 1) ;
}

