#include <iostream.h>
#include <string.h>
#include "widgets.h"
#include "main.h"

#define CENTER 0 

Menu::Menu() {

   nbchoices = 0 ;
   choice = 0 ;
   vibpos = 0 ;
   vibdir = 1 ;
}

void Menu::Set(int nbc, char* t , 
	       char* c0="", char* c1="", char* c2="",
	       char* c3="", char* c4="", char* c5="", 
	       char* c6="", char* c7="", char* c8="", 
	       char* c9="" ) {
   
   strncpy( title, t, 20) ;
   strncpy( text[0], c0, 20) ;
   strncpy( text[1], c1, 20) ;
   strncpy( text[2], c2, 20) ;
   strncpy( text[3], c3, 20) ;
   strncpy( text[4], c4, 20) ;
   strncpy( text[5], c5, 20) ;
   strncpy( text[6], c6, 20) ;
   strncpy( text[7], c7, 20) ;
   strncpy( text[8], c8, 20) ;
   strncpy( text[9], c9, 20) ;
   
   nbchoices=nbc ;
   choice = 0 ;
}

void Menu::Display( ) {
   
   VSDL_Print( 20, 80, fonts, title) ;
   short i;
   for(i=0;i<nbchoices;i++) {
      if ( i != choice )
	VSDL_Print(20,120+i*32, fonts, text[i]) ;
      else
	VSDL_Print(20+vibpos,120+i*32, fonts, text[i]) ;
   }
   vibpos = vibpos + 2 * vibdir ;
   if ( vibpos > 6 ) 
     vibdir = -1 ;
   if ( vibpos < -6 )
     vibdir = +1 ;
}

void Menu::Event( int car) {
   
   switch( car){
    case SDLK_UP:
      Move( MENU_MOVE_UP) ;
      break ;
    case SDLK_DOWN:
      Move( MENU_MOVE_DOWN) ;
      break ;
   }
}

void Menu::Move(short action) {
   
   switch(action) {
    case MENU_MOVE_UP:
      if (choice > 0 )
	choice-- ;
      else if (choice == 0 )
	choice = nbchoices - 1 ;
      break ;
      
    case MENU_MOVE_DOWN:
      if ( choice < nbchoices-1 )
	choice++ ;
      else if ( choice == nbchoices-1 )
	choice = 0 ;
      break ;
   }
}

short Menu::Choose() {
   
   return(choice);
}

Menu::~Menu() {
}

//-+---------- Implementation of Inputbox -----------------------------------+-
InputBox::InputBox( char* title ) {
   
   strncpy( msg, title, 100 ) ;
   content_lng = 0 ;
}

short InputBox::Event( int car, Uint16 unicode) {
   
   if ( car == SDLK_BACKSPACE ) {
      if ( content_lng > 0 ) 
	content_lng-- ;
      return( -1) ;
   }
   else if ( unicode != 0 ) {
     if ( content_lng < 50 ) 
       content[content_lng++] = unicode ;
   }
   return( 0) ;
}

void InputBox::Set( char* str) {
   
   strncpy( content, str, 100) ;
   content_lng = strlen( content) ;
}

char* InputBox::Content() {
   
   content[content_lng] = '\0' ;
   return( content) ;
}

void InputBox::Display() {
   char st[100] ;
   strncpy( st, content, content_lng ) ;
   st[content_lng] = '\0' ;
   VSDL_Print( 20, 160, fonts, msg) ; 
   VSDL_Print( 20, 200, fonts, st) ;
}

InputBox::~InputBox() {
}

