//-+-------------------------------------------------------------------------+-
//    world.cc: classes definition               
//-+-------------------------------------------------------------------------+-
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <math.h>
#include <iostream.h>
#include "def.h"
#include "net.h"
#include "world.h"

//-+------------ Raquette Constructor ---------------------------------------+-
Raquette::Raquette(int x1, int x2, int z1, int z2) {
   int i ;
   
   xMin=x1;
   xMax=x2;
   zMin=z1;
   zMax=z2;
   effect=1;
   power=0.1;
   
   posX = ( xMin + xMax ) / 2 ;
   posY = RK_POSY ;
   posZ = ( zMin + zMax ) / 2 ;
   for(i=0;i<20;i++) {
      last_dx[i] = 0 ;
      last_dy[i] = 0 ;
   }
   last_index = 0 ;
   ex = ey = effect = power = 0 ;
}

//-+---------- Moving a Raquette --------------------------------------------+-
int Raquette::Go( int direction) {
   int i, resist ;
   
   last_index++ ;
   if ( last_index >= 20 )
     last_index = 0 ;
   last_dx[last_index] = 0 ;
   last_dy[last_index] = 0 ;
   
   if ( direction & DIR_UP) {
      last_dy[last_index] += 1 ;
      posZ += 1 ;
   }
   if ( direction & DIR_RIGHT ) {
      last_dx[last_index] += 1 ;
      posX += 1 ;
   }
   if ( direction & DIR_DOWN) {
      last_dy[last_index] -= 1 ;
      posZ -= 1 ;
   }
   if ( direction & DIR_LEFT ) {
      last_dx[last_index] -= 1 ;
      posX -= 1 ;
   }
   ex = 0 ;
   ey = 0 ;
   for(i=0;i<20;i++) {
      ex += (float)last_dx[i] ;
      ey += (float)last_dy[i] ;
   }
   effect = atan2( -ey/100.0, ex/100.0) ;
   /* ex and ey jump from 20 to 0 in one step, Where am I wrong ??? */
   //printf("effect= ex=%f ef=%f -> effect=%f\n",ex,ey,effect) ;
   power = sqrt( ex*ex + ey*ey) ;
   
   /* Should remain inside its area */
   if ( posX > ( xMax - RK_WIDTH/2 ) ) {
      posX = xMax - RK_WIDTH/2 ;
      resist = 1 ;
   }
   if ( posX < ( xMin + RK_WIDTH/2 ) ) {
      posX = xMin + RK_WIDTH/2 ;
      resist = 1 ;
   }
   if ( posZ > ( zMax - RK_DEEP/2  ) ) {
      posZ = zMax - RK_DEEP/2 ;
      resist = 1 ;
   }
   if ( posZ < ( zMin + RK_DEEP/2  ) ) {
      posZ = zMin + RK_DEEP/2 ;
      resist = 1 ;
   }
   return( 1) ;
}

//-+---------- Raquette Destructor ------------------------------------------+-
Raquette::~Raquette() {
}
