#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <SDL_net.h>
#include "main.h"
#include "world_for_SDL.h"
#include "net.h"
#include "playnet.h"

int playNet( int type) {
   World_for_SDL* theWorld ;
   SDL_Event event ;
   Uint8* keyMap ;
   int action ;
   int ret, i ;
   
   theWorld = new World_for_SDL ;
   theWorld->maskComputerPlayers = 0 ;
   theWorld->LoadLevel( "level1") ;
   if ( type == PLAYNET_SERVER)
     ret = theWorld->InitServer() ;
   else
     ret = theWorld->Connect( serverName) ;
   if ( ret)
     return( 1) ;
   
   while( 1) {   
      for(i=0;i<5;i++) {
	 while( SDL_PollEvent(&event) ) {   
	    if ( event.type == SDL_QUIT )
	      return( EXIT) ;
	 }
	 keyMap = SDL_GetKeyState( NULL) ;
	 if ( keyMap[SDLK_ESCAPE] ) {
	    theWorld->CloseNet() ;
	    delete theWorld ;
	    return( MENU) ;
	 }
	 action = 0 ;
	 if ( keyMap[SDLK_UP] )
	   action |= DIR_UP ;
	 if ( keyMap[SDLK_DOWN] )
	   action |= DIR_DOWN ;
	 if ( keyMap[SDLK_LEFT] )
	   action |= DIR_LEFT ;
	 if ( keyMap[SDLK_RIGHT] )
	   action |= DIR_RIGHT ;
	 theWorld->MovePlayer( 1, action) ;
	 if ( type == PLAYNET_SERVER) {
	    theWorld->NetProcessEvents() ;
	    theWorld->Update() ;
	 }
      }
      theWorld->Update() ;
      theWorld->Display() ;
      VSDL_WaitFrame( 50) ;
      VSDL_Update() ;  
   }
}
