//-+-------------------------------------------------------------------------+-
//        Shuffle Puck Cafe                                                    
//        net.h: Include for net game                                          
//               Protocol Definition                                           
//-+-------------------------------------------------------------------------+-
#ifndef _NET_H
#define _NET_H

#include <SDL_net.h>

//-+---------- Default values for addressing --------------------------------+-
#define SERVER_PORT        6789
#define SERVER_PORT_RANGE  10
#define CLIENT_PORT        6790

//-+---------- Some Events --------------------------------------------------+-
#define PLAYER_MOVE        100   // + 1 char: DIR_RIGHT, DIR_UP...             
#define PLAYER_PAUSE       101   // pause or unpeuse the game                  
#define PLAYER_QUIT        102   // abandon                                    

//-+---------- Some Requests ------------------------------------------------+-
#define GIVE_WALLET        200   // Give me the struct WORLD_WALLET            
#define THIS_IS_THE_WALLET 201   // Ok, this is your WORLD_WALLET              
#define GIVE_              201   //                                            

//-+---------- The Wallet to travel the entire world coords -----------------+-
typedef struct {
   unsigned char type ;
   unsigned char nbPlayers ;
   unsigned char noPlayer ;
   unsigned char service ;
   unsigned char score[4] ;
   
   short RposX[4] ;
   short RposY[4] ;
   short RposZ[4];
   
   float BposX ;
   float BposY ;
   float BposZ ;  
   
   char sfx[10] ;
} WORLD_WALLET ;

typedef struct {
   unsigned char type ;
   unsigned char action ;
} PLAYER_ACTION ;

typedef union {
   unsigned char type ;
   PLAYER_ACTION player  ; 
   WORLD_WALLET wallet ;
} REQUEST ;

#endif
