#include <string.h>
#include <VSDL.h>
#include "widgets.h"
#include "main.h"
#include "menu.h"

Menu* CurrentMenu ;
Menu* MainMenu ;
Menu* PlayerMenu ;
Menu* VideoMenu ;
InputBox* HostInput ;
InputBox* NameInput ;
InputBox* ThemeInput ;
InputBox* PhotoInput ;

extern void initMenu() ;

int menu() {
   SDL_Event event ;
   VSDL_pixmap* background = NULL ;
   int currentMenu = MENU_MAIN ;

   background = VSDL_LoadPixmap( "menu.jpg", 0, 0, 0) ;
   initMenu() ;
   while( 1) { 
      while( SDL_PollEvent(&event) ) {
	 if ( event.type == SDL_QUIT )   
	   return( EXIT) ;
	 if ( event.type == SDL_KEYDOWN ) {
	    switch( currentMenu) {
	     case MENU_MAIN:
	       if ( event.key.keysym.sym == SDLK_ESCAPE)
		 return( EXIT) ;
	       else if ( event.key.keysym.sym == SDLK_RETURN) 
		 switch( MainMenu->Choose()) {
		  case 0: VSDL_FreePixmap( background) ; return( PLAY_SOLO) ; break ;
		  case 1: currentMenu = MENU_JOIN ; break ;
		  case 2: currentMenu = MENU_SETUPP ; break ;
		  case 3: currentMenu = MENU_SETUPG ; break ;
		  case 4: VSDL_FreePixmap( background) ; return( PLAY_SERVER) ; break ;
		  case 5: VSDL_FreePixmap( background) ; return( ABOUT) ; break ;
		  case 6: VSDL_FreePixmap( background) ; return( EXIT) ; break ;
		 }
	       else
		 MainMenu->Event( event.key.keysym.sym) ;   
	       break ;
	     case MENU_JOIN:
	       if ( event.key.keysym.sym == SDLK_ESCAPE ) 
		 currentMenu = MENU_MAIN ;
	       else if ( event.key.keysym.sym == SDLK_RETURN ) {
		  strncpy( serverName, HostInput->Content(), 255) ;
		  VSDL_FreePixmap( background) ;
		  return( PLAY_CLIENT) ;
	       }
	       else
		 HostInput->Event( event.key.keysym.sym, event.key.keysym.unicode) ;
	       break ;
	     case MENU_SETUPP:
	       if ( event.key.keysym.sym == SDLK_ESCAPE)
		  currentMenu = MENU_MAIN ; 
	       else if (event.key.keysym.sym == SDLK_RETURN)
		 switch( PlayerMenu->Choose()) {
		  case 0: break ;
		  case 1: break ;
		  case 2: currentMenu = MENU_MAIN ; break ;
		 }
	       else 
		 PlayerMenu->Event( event.key.keysym.sym) ; 
	       break ;
	     case MENU_SETUPG:
	       if( event.key.keysym.sym == SDLK_ESCAPE)
		 currentMenu = MENU_MAIN ;
	       else if ( event.key.keysym.sym == SDLK_RETURN)
		 switch( VideoMenu->Choose()) {
		  case 0: break ;
		  case 1: break ;
		  case 2: break ;
		  case 3: currentMenu = MENU_MAIN ; break ;
		 }
	       else
		 VideoMenu->Event( event.key.keysym.sym) ;
	       break ;
	    }
	 }
      }
      
      VSDL_PutPixmap( background, 0, 0) ;
      switch( currentMenu) {
       case MENU_MAIN: MainMenu->Display() ; break ;
       case MENU_JOIN: HostInput->Display() ; break ;
       case MENU_SETUPP: PlayerMenu->Display() ; break ;
       case MENU_SETUPG: VideoMenu->Display() ; break ;
       case MENU_CREATE: break ;
      }
      VSDL_WaitFrame( 50) ;
      VSDL_Update() ;
   }  
}

//-+---------- Initialize the menus -----------------------------------------+-
void initMenu() {
 
   MainMenu = new Menu ;                /* Instancy the Menus  */
   MainMenu->Set(7,
		 "WELCOME IN THE CAFE",
		 "TOURNAMENT",
		 "JOIN A GAME",
		 "SETUP PLAYER",
		 "SETUP GAME",
		 "CREATE NET GAME",
		 "ABOUT",
		 "GOOD BYE") ;
   PlayerMenu = new Menu ;
   PlayerMenu->Set(3,"PLAYER SETUP",
		   "NAME",
		   "PHOTO",
		   "RETURN") ;
   VideoMenu = new Menu ;
   VideoMenu->Set(4,"GAME SETUP",
		  "THEME",
		  "SCREEN SIZE",
		  "FULL SCREEN",
		  "RETURN") ;
   HostInput = new InputBox( "ENTER A HOST") ;   
   HostInput->Set("localhost") ;
   NameInput = new InputBox( "ENTER YOUR NAME") ;
   PhotoInput = new InputBox( "ENTER A PHOTO") ;
   ThemeInput = new InputBox( "ENTER A THEME") ;
}
