/*
  -+-------------------------------------------------------------------------+-
    Shuffle Puck Cafe:                                Release 0.1 April 2000
                         
                          -+------------------+-
                             The Main Program
                          -+------------------+-

  -+------------------------------------------------------------------------+- 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Jean-Christophe Duberga, 
    duberjc@voila.fr
    10, Rue Solesse
    33290 BLANQUEFORT
    FRANCE
  -+-------------------------------------------------------------------------+-
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <VSDL.h>
#include <SDL_net.h>
#include "menu.h"
#include "tournament.h"
#include "playnet.h"
#include "about.h"
#include "main.h"

VSDL_pixmap* fonts ;        /* not clean */
int mainState = MENU ;
int gameType = PLAY_SOLO ;
char serverName[256] ;

void quit() {
   
   VSDL_FreePixmap( fonts) ;
   SDLNet_Quit() ;
   VSDL_Quit() ;
}

int main( int argc, char* argv[]) {
   char dataPath[256] ;
   int i ;
   int flags ;
   
   /* Process parameters */
   strncpy( dataPath, DEFAULT_PATH, 256) ;
   flags = VSDL_FULLSCREEN|VSDL_ACCEL ;
   for(i=1;i<argc;i++) {
      if ( strcmp( argv[i], "--help") == 0 ) {
	 printf("usage: %s [options]\n\n", argv[0]) ;
	 printf("options are:\n") ;
	 printf("  --help        Display this help notice\n") ;
	 printf("  --fullscreen  Play in fullscreen (default)\n") ;
	 printf("  --window      Play in windowed\n") ;
	 printf("  --nosound     Disable the sound\n\n") ;
	 exit( 1) ;
      }
      else if ( strcmp( argv[i], "--window") == 0 )
	flags = flags & ~VSDL_FULLSCREEN ;
      else if ( strcmp( argv[i], "--nosound") == 0 )
	;
   }
   printf("Thank you for trying Shuflle Puck Cafe rel:%s\n",RELEASE) ;
   VSDL_SetPath( dataPath) ;
   VSDL_SetMode( 640, 480, flags) ;
   SDL_WM_SetCaption( "Shuffle Puck Cafe", "shuffle puck cafe" ) ;
   SDL_ShowCursor( 0) ;
   fonts = VSDL_LoadPixmap( "fa3.png", 1, 0, 0) ;
   SDL_EnableUNICODE( 1) ;
   VSDL_OpenMixer( 22049, 16, 2 ) ;
   if ( SDLNet_Init() < 0 ) {
      fprintf( stderr, "Couldn,t initialize net: %s\n", SDLNet_GetError()) ;
   }
   
   mainState = MENU ;
   while( 1) {
      switch( mainState) {
       case MENU: mainState = menu() ; break ;
       case PLAY_SOLO: mainState = tournament() ; break ;
       case PLAY_CLIENT:  mainState = playNet( PLAYNET_CLIENT) ; break ; 
       case PLAY_SERVER: mainState = playNet( PLAYNET_SERVER) ; break ;
       case ABOUT: mainState = about() ; break ;
       case EXIT: SDL_Quit() ; exit(0) ; break ;
      }
   }
}
