
#ifndef _VSDL_VIDEO_H
#define _VSDL_VIDEO_H

#include <SDL/SDL.h>
#include "VSDL.h"

/* Flags for VSDL_SetMode */
#define VSDL_FULLSCREEN 1
#define VSDL_ACCEL      2
#define VSDL_DOUBLEBUF  4
#define VSDL_GL         8

extern SDL_Surface *vsdl_screen ;
extern int vsdl_videoReady ;
extern int vsdl_videoFlags ;

extern int VSDL_SetMode( int w, int h, int flags) ;
extern int VSDL_SetVirtualScreen( int w, int h) ;
extern int VSDL_UpdateScreen() ;
extern int VSDL_WaitFrame( int fps) ;
extern void VSDL_SetColor( Uint8 r, Uint8 g, Uint8 b ) ;
extern void VSDL_Fill() ;
extern void VSDL_PutRect( int x, int y, int w, int h) ;
extern void VSDL_PutPoint( int x, int y) ;
extern void VSDL_PutLine( int x1, int y1, int x2, int y2) ; 
extern void VSDL_PutTriangle( int x1, int y1, int x2, int y2, int x3, int y3) ; 
   
#endif
