#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <memory.h>
#include "VSDL_video.h"

/* global var declaration end */
int vsdl_videoReady = 0 ;
int vsdl_videoFlags = 0 ;   
SDL_Surface *vsdl_screen = NULL ;

/* private variables declaration */
Uint32 vsdl_currentColor = 0 ;

/* set the video mode */
int VSDL_SetMode( int w , int h, int flags) {
   
   vsdl_videoFlags = SDL_ANYFORMAT ;
   if ( flags & VSDL_FULLSCREEN )
     vsdl_videoFlags |= SDL_FULLSCREEN ;
   if ( flags & VSDL_ACCEL )
     vsdl_videoFlags |= SDL_HWSURFACE ;
   if ( flags & VSDL_DOUBLEBUF )
     vsdl_videoFlags |=  SDL_DOUBLEBUF ;
   if ( flags & VSDL_GL ) 
     vsdl_videoFlags |= SDL_OPENGL ;
   if ( SDL_Init(SDL_INIT_VIDEO) < 0 ) {
      fprintf(stderr,"Couldn't init video\n") ;
      exit( -1) ;
   }
 
   if ((vsdl_screen=SDL_SetVideoMode( w, h, 32, vsdl_videoFlags)) == NULL ) {
      fprintf(stderr, "Couldn't set %dx%dxanybpp video mode: %s\n",
	      w,h,SDL_GetError());
      exit(-1) ;
   }
   printf("Set %dx%d at %d successfully.\n",
	  vsdl_screen->w,
	  vsdl_screen->h,
	  (int)vsdl_screen->format->BitsPerPixel) ;
   vsdl_videoReady = 1 ;
   return(1) ;
}

/* Update the screen */
int VSDL_UpdateScreen() {
   
   if ( vsdl_videoReady != 1 )
     return( -1) ; 
   SDL_Flip( vsdl_screen) ;
   return( 1) ;
}

/* Wait for the next frame */
int VSDL_WaitFrame( int fps) {
   static Uint32 next_tick = 0 ;
   Uint32 this_tick ;
   int realfps ;
   
   this_tick = SDL_GetTicks() ;
   if ( this_tick <= next_tick ) {
      SDL_Delay( next_tick-this_tick) ;
      realfps = fps ;
   }
   else 
     realfps = 1000/(1000/fps+this_tick-next_tick) ;
   
   next_tick = SDL_GetTicks() + (1000/fps) ; 
   return( realfps) ; /* return the real fps */
}

/* Set the current color */
void VSDL_SetColor( Uint8 r, Uint8 g , Uint8 b ) {
   if ( vsdl_videoReady != 1) 
     return ;
   vsdl_currentColor = SDL_MapRGB( vsdl_screen->format, r, g, b) ;
}

/* Fill the screen with the cuurent color */
void VSDL_Fill() {  
   SDL_Rect myRect ;
   
   if ( vsdl_videoReady != 1 )
     return ;
   myRect.x = 0 ;
   myRect.y = 0 ;
   myRect.w = vsdl_screen->w ;
   myRect.h = vsdl_screen->h ;
   SDL_FillRect( vsdl_screen, &myRect, vsdl_currentColor) ;
}


/* Put a rect */
void VSDL_PutRect( int x, int y, int w, int h) {
   SDL_Rect myRect ;
   
   if ( vsdl_videoReady != 1 )
     return ;
  
   myRect.x = x ;
   myRect.y = y ;
   myRect.w = w ;
   myRect.h = h ;
   SDL_FillRect( vsdl_screen, &myRect, vsdl_currentColor) ;
}

/* put a point of the current color */
void VSDL_PutPoint( int x , int y ) {
   Uint8 bpp ;
   
   if ( vsdl_videoReady != 1)
     return ;
   
   if ( x >= 0 && x < vsdl_screen->w-1 && y >= 0 && y < vsdl_screen->h-1 ) {
      if ( SDL_MUSTLOCK(vsdl_screen) ) {
	 if ( SDL_LockSurface(vsdl_screen) < 0 )
	   return ;
      }
      bpp = vsdl_screen->format->BytesPerPixel ;
      switch( bpp) {
       case 2: {
	  *((Uint16 *)(((Uint8 *)vsdl_screen->pixels)+y*vsdl_screen->pitch+x*bpp)) = (Uint16)vsdl_currentColor ;
       } break ;
       case 3: { /* Format/endian independent */
	  Uint8 r, g, b;
	  r = (vsdl_currentColor>>vsdl_screen->format->Rshift)&0xFF ;
	  g = (vsdl_currentColor>>vsdl_screen->format->Gshift)&0xFF ;
	  b = (vsdl_currentColor>>vsdl_screen->format->Bshift)&0xFF ;
	  *((((Uint8 *)vsdl_screen->pixels)+y*vsdl_screen->pitch+x*bpp)+vsdl_screen->format->Rshift/8) = r ;
	  *((((Uint8 *)vsdl_screen->pixels)+y*vsdl_screen->pitch+x*bpp)+vsdl_screen->format->Gshift/8) = g ;
	  *((((Uint8 *)vsdl_screen->pixels)+y*vsdl_screen->pitch+x*bpp)+vsdl_screen->format->Bshift/8) = b ;
       } break ;
       case 4: {
	  *((Uint32 *)(((Uint8 *)vsdl_screen->pixels)+y*vsdl_screen->pitch+x*bpp)) = (Uint32)vsdl_currentColor ;
       } break ;
      }
      if ( SDL_MUSTLOCK(vsdl_screen) ) {
	 SDL_UnlockSurface(vsdl_screen) ;
      }
   }
}

/* Put a line */
void VSDL_PutLine( int x1 , int y1 , int x2 , int y2 ) {
   int Xdiff, Ydiff, diff ;
   float x, y, stepX, stepY ;
   int i ;
   
   if ( vsdl_videoReady != 1) 
     return ;
   
   Xdiff = x2 - x1 ;
   Ydiff = y2 - y1 ;
   
   if ( abs(Xdiff) >= abs(Ydiff) ) { /* draw by the x */ 
      if ( Xdiff > 0 ) {
	 diff = Xdiff ;
	 x = x1 ;
	 y = y1 ;
      }
      else {
	 diff = -Xdiff ;
	 x = x2 ;
	 y = y2 ;
      }
      stepX = 1 ;
      stepY = (float)Ydiff / (float)Xdiff ;
   }
   else { /* else draw by the y */
      if ( Ydiff > 0 ) {
	 diff = Ydiff ;
	 x = x1 ;
	 y = y1 ;
      }
      else {
	 diff = -Ydiff ;
	 x = x2 ;
	 y = y2 ;
      }
      stepX = (float)Xdiff / (float)Ydiff ;
      stepY = 1 ;
   }
   for(i=0;i<diff;i++) {
      x = x + stepX ;
      y = y + stepY ;
      VSDL_PutPoint( (int)x, (int)y) ;
   }
}

/* Put a triangle */
void VSDL_PutTriangle( int x1 , int y1 , int x2 ,int y2 ,int x3 , int y3 ) {
   int Xdiff, Ydiff, diff ;
   float x, y, stepX, stepY ;
   int i, j ;
   int ymin, ymax ;
   int hline[vsdl_screen->w][2] ;
   int tmp ;
   
   if ( vsdl_videoReady != 1 )
     return ;
   
   ymin = y1 ;
   if ( y2 < ymin ) 
     ymin = y2 ;
   if ( y3 < ymin )
     ymin = y3 ;
   
   ymax = y1 ;
   if ( y2 > ymax )
     ymax = y2 ;
   if ( y3 > ymax )
     ymax = y3 ;
   
   for (j=0;j<vsdl_screen->w;j++) {
      hline[j][0]=-1 ;
      hline[j][1]=-1 ;
   }
   
   for(j=0;j<3;j++) {  /* for the three lines */
      Xdiff = x2 - x1 ;
      Ydiff = y2 - y1 ;
      if ( abs(Xdiff) >= abs(Ydiff) ) { /* draw by the x */
	 if ( Xdiff > 0 ) {
	    diff = Xdiff ;
	    x = x1 ;
	    y = y1 ;
	 }
	 else {
	    diff = -Xdiff ;
	    x = x2 ;
	    y = y2 ;
	 }
	 stepX = 1 ;
	 stepY = (float)Ydiff / (float)Xdiff ;
      }
      else { /* else draw by the y */
	 if ( Ydiff > 0 ) {
	    diff = Ydiff ;
	    x = x1 ;
	    y = y1 ;
	 }
	 else {
	    diff = -Ydiff ;
	    x = x2 ;
	    y = y2 ;
	 }
	 stepX = (float)Xdiff / (float)Ydiff ;
	 stepY = 1 ;
      }
      for(i=0;i<diff;i++) {
	 x = x + stepX ;
	 y = y + stepY ;
	 /* Instead of displaying the point, keep it */
	 if ( (int)x < hline[(int)y][0] || hline[(int)y][0]==-1 )
	   hline[(int)y][0] = (int)x ;
	 if ( (int)x > hline[(int)y][1] || hline[(int)y][1]==-1 )
	   hline[(int)y][1] = (int)x ;
      }	
      tmp = x1 ;
      x1 = x2 ;
      x2 = x3 ;
      x3 = tmp ;
      tmp = y1 ;
      y1 = y2 ;
      y2 = y3 ;
      y3 = tmp ;
   }
   
   for(j=ymin;j<=ymax;j++) /* draw the horizontal lines */
     for(i=hline[j][0];i<=hline[j][1];i++) {
    	VSDL_PutPoint( i, j) ;
     }
}
