
#ifndef _VSDL_SPRITE_H
#define _VSDL_SPRITE_H

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>

/* Flags for VSDL_Write */
#define VSDL_LEFT       0
#define VSDL_CENTERED   1
#define VSDL_RIGHT      2
#define VSDL_JUSTIFIED  4

typedef struct {
   char name[256] ;
   SDL_Surface *image ;
   char transparency ;
   char alpha ;
   char nbFrames ;
   char speed ;
   char currentTime ;
   char currentFrame ;
   char ready ;
} VSDL_pixmap ;

typedef struct {
   VSDL_pixmap* font[256] ;
   int w ;
   int h ;
} VSDL_fonts ;

extern VSDL_pixmap* VSDL_LoadPixmap( char* filename, char tr, char alpha, int flags) ;
extern int VSDL_PutPixmap( VSDL_pixmap* pixmap, int x, int y) ;
extern VSDL_pixmap* VSDL_ScalePixmap( VSDL_pixmap* pixmap, int x,int y) ;
extern VSDL_pixmap* VSDL_RotatePixmap( VSDL_pixmap* pixmap, float angle) ;
extern void VSDL_FreePixmap( VSDL_pixmap* pixmap) ;

extern int VSDL_InitAnimatedPixmap( VSDL_pixmap* pixmap, char nbFrames, char speed) ;
extern int VSDL_PushAnimatedPixmap( VSDL_pixmap* pixmap) ;

extern void VSDL_Print( int x, int y, VSDL_pixmap* font, char* text) ;

#endif
