#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <memory.h>
#include "VSDL.h"
#include "VSDL_soft3d.h"

#define MAX_TRI 1000

float vsdl_soft3d_teta ; 
float vsdl_soft3d_phy ;
int vsdl_soft3d_D ;
int vsdl_soft3d_R ;
int vsdl_soft3d_Xcenter ;
int vsdl_soft3d_Ycenter ;
int vsdl_soft3d_nbTri ;
VSDL_soft3d_tri* vsdl_soft3d_tri[MAX_TRI] ;
Uint32 vsdl_soft3d_currentColor ;
extern SDL_Surface* vsdl_screen ;
extern Uint32 vsdl_currentColor ;

/* Init the camera */
int VSDL_soft3d_SetCamera( int nR, int nD, float nteta, float nphy, int nXc, int nYc ) {
   vsdl_soft3d_R = nR ;
   vsdl_soft3d_D = nD ;
   vsdl_soft3d_teta = nteta ;   
   vsdl_soft3d_phy = nphy ;
   vsdl_soft3d_Xcenter = nXc ;
   vsdl_soft3d_Ycenter = nYc ;
   vsdl_soft3d_nbTri = 0 ;
   return( 1) ;
}

/* Select the color */
void VSDL_soft3d_SetColor( int r, int g, int b) {
   
   vsdl_soft3d_currentColor = SDL_MapRGB( vsdl_screen->format, r, g, b) ;
}

/* Put a triangle */
void VSDL_soft3d_PutTriangle(int x1, int y1, int z1,
			     int x2, int y2, int z2,
			     int x3, int y3, int z3)
{
   delete vsdl_soft3d_tri[vsdl_soft3d_nbTri] ;
   vsdl_soft3d_tri[vsdl_soft3d_nbTri] = new VSDL_soft3d_tri ;
   vsdl_soft3d_tri[vsdl_soft3d_nbTri]->pt1.x = x1 ;
   vsdl_soft3d_tri[vsdl_soft3d_nbTri]->pt1.y = y1 ;
   vsdl_soft3d_tri[vsdl_soft3d_nbTri]->pt1.z = z1 ;
   vsdl_soft3d_tri[vsdl_soft3d_nbTri]->pt2.x = x2 ;
   vsdl_soft3d_tri[vsdl_soft3d_nbTri]->pt2.y = y2 ;
   vsdl_soft3d_tri[vsdl_soft3d_nbTri]->pt2.z = z2 ;
   vsdl_soft3d_tri[vsdl_soft3d_nbTri]->pt3.x = x3 ;
   vsdl_soft3d_tri[vsdl_soft3d_nbTri]->pt3.y = y3 ;
   vsdl_soft3d_tri[vsdl_soft3d_nbTri]->pt3.z = z3 ;
   vsdl_soft3d_tri[vsdl_soft3d_nbTri]->color = vsdl_soft3d_currentColor ;
   if ( vsdl_soft3d_nbTri < MAX_TRI )
     vsdl_soft3d_nbTri++ ;
}

//-+---------- Launch a rendering -------------------------------------------+-
int VSDL_soft3d_Render( ) {
   int i, j ;
   float steta,cteta,sphy,cphy ;
   int R, D ;
   int zBuffer[MAX_TRI] ;
   int aux ;
   
   steta = sin(vsdl_soft3d_teta) ;
   cteta = cos(vsdl_soft3d_teta) ;
   sphy = sin(vsdl_soft3d_phy) ;
   cphy = cos(vsdl_soft3d_phy) ;
   R = vsdl_soft3d_R ;
   D = vsdl_soft3d_D ;
   
   for(i=0;i<vsdl_soft3d_nbTri;i++) {
      vsdl_soft3d_tri[i]->ptO1.x =(int)( -vsdl_soft3d_tri[i]->pt1.x*steta + vsdl_soft3d_tri[i]->pt1.y*cteta ) ;
      vsdl_soft3d_tri[i]->ptO1.y =(int)( -vsdl_soft3d_tri[i]->pt1.x*cteta*sphy - vsdl_soft3d_tri[i]->pt1.y*steta*sphy + vsdl_soft3d_tri[i]->pt1.z*cphy ) ;
      vsdl_soft3d_tri[i]->ptO1.z =(int)( -vsdl_soft3d_tri[i]->pt1.x*cteta*sphy - vsdl_soft3d_tri[i]->pt1.y*steta*cphy + vsdl_soft3d_tri[i]->pt1.z*sphy + R ) ;
      
      vsdl_soft3d_tri[i]->ptO2.x =(int)( -vsdl_soft3d_tri[i]->pt2.x*steta + vsdl_soft3d_tri[i]->pt2.y*cteta ) ;
      vsdl_soft3d_tri[i]->ptO2.y =(int)( -vsdl_soft3d_tri[i]->pt2.x*cteta*sphy - vsdl_soft3d_tri[i]->pt2.y*steta*sphy + vsdl_soft3d_tri[i]->pt2.z*cphy ) ;
      vsdl_soft3d_tri[i]->ptO2.z =(int)( -vsdl_soft3d_tri[i]->pt2.x*cteta*sphy - vsdl_soft3d_tri[i]->pt2.y*steta*cphy + vsdl_soft3d_tri[i]->pt2.z*sphy + R ) ;
      
      vsdl_soft3d_tri[i]->ptO3.x =(int)( -vsdl_soft3d_tri[i]->pt3.x*steta + vsdl_soft3d_tri[i]->pt3.y*cteta ) ;
      vsdl_soft3d_tri[i]->ptO3.y =(int)( -vsdl_soft3d_tri[i]->pt3.x*cteta*sphy - vsdl_soft3d_tri[i]->pt3.y*steta*sphy + vsdl_soft3d_tri[i]->pt3.z*cphy ) ;
      vsdl_soft3d_tri[i]->ptO3.z =(int)( -vsdl_soft3d_tri[i]->pt3.x*cteta*sphy - vsdl_soft3d_tri[i]->pt3.y*steta*cphy + vsdl_soft3d_tri[i]->pt3.z*sphy + R ) ;
      vsdl_soft3d_tri[i]->zbuf = ( vsdl_soft3d_tri[i]->ptO1.z + vsdl_soft3d_tri[i]->ptO2.z + vsdl_soft3d_tri[i]->ptO3.z ) / 3 ; 
   }
   /* quick sort on the z */
   for(i=0;i<vsdl_soft3d_nbTri;i++)
     zBuffer[i] = i ;
   for(i=0;i<vsdl_soft3d_nbTri;i++)
     for(j=i;j<vsdl_soft3d_nbTri;j++) {
	if ( vsdl_soft3d_tri[zBuffer[i]]->zbuf < vsdl_soft3d_tri[zBuffer[j]]->zbuf ) {
	   aux = zBuffer[i] ;
	   zBuffer[i] = zBuffer[j] ;
	   zBuffer[j] = aux ;
	}
     }
   
   /* and so display the faces */
   for(j=0;j<vsdl_soft3d_nbTri;j++) {
      i = zBuffer[j] ;
      vsdl_currentColor = vsdl_soft3d_tri[i]->color ;
      VSDL_PutTriangle(D * vsdl_soft3d_tri[i]->ptO1.x / vsdl_soft3d_tri[i]->ptO1.z + vsdl_soft3d_Xcenter , D * vsdl_soft3d_tri[i]->ptO1.y / vsdl_soft3d_tri[i]->ptO1.z + vsdl_soft3d_Ycenter ,
		       D * vsdl_soft3d_tri[i]->ptO2.x / vsdl_soft3d_tri[i]->ptO2.z + vsdl_soft3d_Xcenter , D * vsdl_soft3d_tri[i]->ptO2.y / vsdl_soft3d_tri[i]->ptO2.z + vsdl_soft3d_Ycenter ,
		       D * vsdl_soft3d_tri[i]->ptO3.x / vsdl_soft3d_tri[i]->ptO3.z + vsdl_soft3d_Xcenter , D * vsdl_soft3d_tri[i]->ptO3.y / vsdl_soft3d_tri[i]->ptO3.z + vsdl_soft3d_Ycenter ) ;   
   }
   vsdl_soft3d_nbTri = 0 ;
   return( 1) ;
}
