
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>

#include <SDL/SDL.h>
#include "VSDL_mixer.h"

/* global variables */
int vsdl_mixer_rate ;
Uint16 vsdl_mixer_format ;
int vsdl_mixer_chanels ;
/* extern var */
extern int vsdl_mixerReady ;
extern char vsdl_path[512] ;

/*
void CleanUp(void)
{
	if ( audio_open ) {
		Mix_CloseAudio();
		audio_open = 0;
	}
	if ( wave ) {
		Mix_FreeChunk(wave);
		wave = NULL;
	}
	SDL_Quit();
}*/

/* Open the mixer */
int VSDL_OpenMixer( int rate, int format, int nbchanels ) {
   
   vsdl_mixer_rate = rate ;
   vsdl_mixer_format = format ;
   vsdl_mixer_chanels = nbchanels ;
   if ( SDL_Init(SDL_INIT_AUDIO) < 0 ) {
      fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
      exit( -3) ;
   }
   /* Open the audio device */
   if (Mix_OpenAudio( vsdl_mixer_rate, vsdl_mixer_format, vsdl_mixer_chanels, 512) < 0) {
      fprintf(stderr, "Couldn't open audio: %s\n", SDL_GetError());
      exit( -3) ;
   } else {
      Mix_QuerySpec(&vsdl_mixer_rate, &vsdl_mixer_format, &vsdl_mixer_chanels);
      printf("Opened audio at %d Hz %d bit %s\n", vsdl_mixer_rate,
	     (vsdl_mixer_format&0xFF),
	     (vsdl_mixer_chanels > 1) ? "stereo" : "mono") ;
   }
   vsdl_mixerReady = 1 ;
   return( 1) ;
}

/* Load a wave file */
VSDL_sound* VSDL_LoadSound( char* fileName) {
   VSDL_sound* sound ;
   char filePath[512] ;
   
   sound = new VSDL_sound ;
   
   if ( vsdl_path != NULL )
     sprintf( filePath, "%s/%s", vsdl_path, fileName) ;
   else
     strncpy( filePath, fileName, 512) ;
   
   sound->sample = Mix_LoadWAV( filePath) ;
   if ( sound->sample == NULL ) {  
      fprintf(stderr, "Couldn't load %s: %s\n",
	      filePath, SDL_GetError()) ;
   }
   else {
      sound->ready = 1 ;
   }
   return( sound) ;
}

/* To play a wave */
int VSDL_PlaySound( VSDL_sound* sound) {
   
   if ( sound != NULL ) {
      if ( sound->ready == 1 ) {
	 Mix_PlayChannel( -1, sound->sample, 0) ;   
	 return( 1) ;
      }
      else {
	 return( -2) ;
      }
   }
   else
     return( -1) ;
}
 
void VSDL_UpdateMixer() {
   
   Mix_Playing( -1) ;
}
