#include <stdio.h>
#include <stdlib.h>
#include "VSDL.h"

extern int vsdl_videoReady ;
extern SDL_Surface *vsdl_screen ;

void VSDL_DisplayInfo() {
   SDL_Event event ;
   const SDL_VideoInfo* info ;
   char tmp[256] ;
   
   if ( vsdl_videoReady != 1 ) 
     return ;
   info = SDL_GetVideoInfo() ;
   while( 1) {
      while( SDL_PollEvent( &event) ) {
	 if ( event.type == SDL_QUIT ) {
	    SDL_Quit() ;
	    exit(0) ;
	 }
	 if ( event.type == SDL_KEYDOWN )
	   return ;
      }
      VSDL_SetColor( 0, 0, 0) ;
      VSDL_Fill() ;
     /* VSDL_Write( 0, 20, "<< Information note >>", VSDL_CENTERED) ;
      
      sprintf(tmp, "Resolution: %dx%d pixels", vsdl_screen->w, vsdl_screen->h) ;
      VSDL_Write( 10,60, tmp, 0 ) ;
      
      sprintf(tmp, "Bits Per Pixel: %d bpp", vsdl_screen->format->BitsPerPixel) ;
      VSDL_Write( 10,80, tmp, 0 ) ;
      
      if ( info->hw_available )
	sprintf(tmp, "Hardawre Surfaces: YES") ;
      else
	sprintf(tmp, "Hardware Surfaces: NO") ;
      VSDL_Write( 10, 100, tmp, 0) ;
      
      if ( info->blit_hw )
	sprintf(tmp, "Blit Hardware Accelerated: YES ") ;
      else
	sprintf(tmp, "Blit Hardware Accelerated: NO") ;
      VSDL_Write( 10, 120, tmp, 0) ;
      
      if ( info->blit_hw_CC )
	sprintf(tmp, "Transparency Blit Hardware Accelerated: YES ") ;
      else
	sprintf(tmp, "Transparency Blit Hardware Accelerated: NO") ;
      VSDL_Write( 10, 140, tmp, 0) ;
      
      if ( info->blit_hw_A )
	sprintf(tmp, "Alpha Blit Hardware Accelerated: YES ") ;
      else
	sprintf(tmp, "Alpha Blit Hardware Accelerated: NO") ;
      VSDL_Write( 10, 160, tmp, 0) ;
 
      if ( info->blit_sw )
	sprintf(tmp, "Blit System Accelerated: YES ") ;
      else
	sprintf(tmp, "Blit System Accelerated: NO") ;
      VSDL_Write( 10, 180, tmp, 0) ;
      
      if ( info->blit_sw_CC )
	sprintf(tmp, "Transparency Blit System Accelerated: YES ") ;
      else
	sprintf(tmp, "Transparency Blit System Accelerated: NO") ;
      VSDL_Write( 10, 200, tmp, 0) ;
      
      if ( info->blit_sw_A )
	sprintf(tmp, "Alpha Blit System Accelerated: YES ") ;
      else
	sprintf(tmp, "Alpha Blit System Accelerated: NO") ;
      VSDL_Write( 10, 220, tmp, 0) ;
      
      if ( info->blit_fill )
	sprintf(tmp, "Fill Accelerated: YES ") ;
      else
	sprintf(tmp, "Fill Accelerated: NO") ;
      VSDL_Write( 10, 240, tmp, 0) ;
      
      sprintf(tmp, "Size of Video Memory: %d Ko", info->video_mem) ;
      VSDL_Write( 10,260, tmp, 0 ) ;
      
      sprintf(tmp, "AutoRepeat: Disabled") ;
      VSDL_Write( 10,280, tmp, 0 ) ;
      
      //sprintf(tmp, "Sound 22 Khz 8 bits stereo ", 0 ) ;
      //VSDL_Write( 10,280, tmp, 0 ) ;
      
      VSDL_Write( 0, 440, "-------------------------------------------------------------------------------------", 0) ;
      VSDL_Write( 0, 460, "If you have any problem, mail me: jeanchristophe.duber@free.fr",VSDL_CENTERED) ;
      */
      VSDL_UpdateScreen() ;
      VSDL_WaitFrame( 50) ;
   }  
}
