#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <GL/gl.h>
#include "VSDL.h"

int VSDL_InitGl() {
   int rgb_size[3];  
   int value ;
   int bpp ;
   
   bpp = 16 ;
   
   /* Initialize the display */
   switch (bpp) {
    case 8:
      rgb_size[0] = 2;
      rgb_size[1] = 3;
      rgb_size[2] = 3;
      break;
    case 15:
      rgb_size[0] = 5;
      rgb_size[1] = 5;
      rgb_size[2] = 5;
      break ;
    case 16:
      rgb_size[0] = 5;
      rgb_size[1] = 6;
      rgb_size[2] = 5;
      break;
    default:
      rgb_size[0] = 8;
      rgb_size[1] = 8;
      rgb_size[2] = 8;
      break;
   }
   SDL_GL_SetAttribute( SDL_GL_RED_SIZE, rgb_size[0] );
   SDL_GL_SetAttribute( SDL_GL_GREEN_SIZE, rgb_size[1] );
   SDL_GL_SetAttribute( SDL_GL_BLUE_SIZE, rgb_size[2] );
   SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16 );
   SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );
   
   printf("\n");
   printf( "Vendor     : %s\n", glGetString( GL_VENDOR ) );
   printf( "Renderer   : %s\n", glGetString( GL_RENDERER ) );
   printf( "Version    : %s\n", glGetString( GL_VERSION ) );
   printf( "Extensions : %s\n", glGetString( GL_EXTENSIONS ) );
   printf("\n");
   
   SDL_GL_GetAttribute( SDL_GL_RED_SIZE, &value );
   printf( "SDL_GL_RED_SIZE: requested %d, got %d\n", rgb_size[0],value);
   SDL_GL_GetAttribute( SDL_GL_GREEN_SIZE, &value );
   printf( "SDL_GL_GREEN_SIZE: requested %d, got %d\n", rgb_size[1],value);
   SDL_GL_GetAttribute( SDL_GL_BLUE_SIZE, &value );
   printf( "SDL_GL_BLUE_SIZE: requested %d, got %d\n", rgb_size[2],value);
   SDL_GL_GetAttribute( SDL_GL_DEPTH_SIZE, &value );
   printf( "SDL_GL_DEPTH_SIZE: requested %d, got %d\n", bpp, value );
   SDL_GL_GetAttribute( SDL_GL_DOUBLEBUFFER, &value );
   printf( "SDL_GL_DOUBLEBUFFER: requested 1, got %d\n", value );
   
   return( 1) ;
}

GLuint VSDL_LoadTexture(char *fileName) {
   Uint8 *rowhi, *rowlo;
   Uint8 *tmpbuf, tmpch;
   SDL_Surface *image, *image2 ;
   SDL_PixelFormat glPixelFormat ;
   char filePath[512] ;
   int i, j;
   GLuint noTexture ;
      
   if ( vsdl_path != NULL )
     sprintf( filePath, "%s/%s", vsdl_path, fileName) ;
   else
     strncpy( filePath, fileName, 512) ;
   
   image2 = IMG_Load( filePath) ;
   if ( image2 == NULL ) {
      fprintf(stderr, "Unable to load %s: %s\n", filePath, SDL_GetError());
      return( 0) ;
   }
   
   glPixelFormat.palette = NULL ;
   glPixelFormat.BitsPerPixel = 24 ;
   glPixelFormat.BytesPerPixel = 3 ;
   glPixelFormat.Rmask = 0xFF0000;
   glPixelFormat.Gmask = 0x00FF00 ;
   glPixelFormat.Bmask = 0x0000FF ;
   glPixelFormat.Amask = 0x000000 ;
   glPixelFormat.Rshift = 0x10 ; 
   glPixelFormat.Gshift = 0x8 ; 
   glPixelFormat.Bshift = 0x0 ; 
   glPixelFormat.Ashift = 0 ;
   glPixelFormat.Rloss = 0 ; 
   glPixelFormat.Gloss = 0 ; 
   glPixelFormat.Bloss = 0 ; 
   glPixelFormat.Aloss = 0x8 ;
   glPixelFormat.colorkey = 0x0 ;
   glPixelFormat.alpha = 0xFF ;
   image = SDL_ConvertSurface( image2, &glPixelFormat, SDL_SWSURFACE) ;
   if ( image == NULL ) {
      printf("erreur de conversion\n") ;
      SDL_FreeSurface( image2) ;
      return( 0) ;
   }
   SDL_FreeSurface( image2) ;
   
   /* GL surfaces are upsidedown and RGB, not BGR :-) */
   tmpbuf = (Uint8 *)malloc(image->pitch);
   if ( tmpbuf == NULL ) {
      fprintf(stderr, "Out of memory\n");
      return( 0) ;
   }
   rowhi = (Uint8 *)image->pixels;
   rowlo = rowhi + (image->h * image->pitch) - image->pitch;
   for ( i=0; i<image->h/2; ++i ) {
      for ( j=0; j<image->w; ++j ) {
	 tmpch = rowhi[j*3];
	 rowhi[j*3] = rowhi[j*3+2];
	 rowhi[j*3+2] = tmpch;
	 tmpch = rowlo[j*3];
	 rowlo[j*3] = rowlo[j*3+2];
	 rowlo[j*3+2] = tmpch;
      }
      memcpy(tmpbuf, rowhi, image->pitch);
      memcpy(rowhi, rowlo, image->pitch);
      memcpy(rowlo, tmpbuf, image->pitch);
      rowhi += image->pitch;
      rowlo -= image->pitch;
   }
   free(tmpbuf) ;
   
   glGenTextures( 1, &noTexture) ;
   glBindTexture( GL_TEXTURE_2D, noTexture) ;
   glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR) ;
   glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR) ;
   glPixelStorei( GL_UNPACK_ALIGNMENT, 1) ;
   glTexImage2D(GL_TEXTURE_2D, 0, 3, image->w, image->h, 0, GL_RGB, GL_UNSIGNED_BYTE, image->pixels) ;

//   gluBuild2DMipmaps(GL_TEXTURE_2D, 3, image->w, image->h,
//		     GL_RGB, GL_UNSIGNED_BYTE, image->pixels);
   SDL_FreeSurface( image) ;
   return( noTexture) ;
}

void VSDL_glPrint( float x, float y, float z, GLuint font, char* text) {
   int lng, i ;
   float x2 ;
   float xLetter, yLetter ;
   
   lng = strlen( text) ;
   glBindTexture( GL_TEXTURE_2D, font) ;
   glEnable( GL_TEXTURE_2D) ;
   for(i=0;i<lng;i++) {
      x2 = x + 0.1 * (float)i ;
      xLetter = 0.1 * (float)( (text[i]-33) % 10) ;
      yLetter = 1.0 - 0.1 * (float)( (text[i]-33) / 10) - 0.1;
      glBegin( GL_QUADS) ;
      glTexCoord2f( xLetter,     yLetter    ) ; glVertex3f( x2, y, -z) ;
      glTexCoord2f( xLetter+0.1, yLetter    ) ; glVertex3f( x2+0.1, y, -z) ;
      glTexCoord2f( xLetter+0.1, yLetter+0.1) ; glVertex3f( x2+0.1, y+0.1, -z) ;
      glTexCoord2f( xLetter,     yLetter+0.1) ; glVertex3f( x2, y+0.1, -z) ;
      glEnd() ;
   }
   glDisable( GL_TEXTURE_2D) ;
}
