#ifndef _MIDI_TIMER_HPP
#define _MIDI_TIMER_HPP

class Midi_Timer
{
 public:
   Midi_Timer();
   ~Midi_Timer();
   int Initialize();
   
   void SetMidiTickDuration( unsigned int midi_tick_duration);
   
   void Start();
   void Play();
   void Pause();
   
   unsigned int GetUSec();
   unsigned int GetMidiTicks();
   
   void WaitUntilUsec( unsigned int usec);
   void WaitUntilMidiTick( unsigned int midi_tick);
   
 private:
   int state;
   unsigned int midi_tick_duration;//TODO add modulo to keep precision
   unsigned int time_in_usec;
   unsigned int time_in_midi_ticks;
   unsigned int last_usec;
};

#endif
