#include "midi_timer.hpp"
#include <stdlib.h>
#include <SDL.h>

#define DEFAULT_MIDI_TICK_DURATION 4*387

Midi_Timer::Midi_Timer()
{
   midi_tick_duration = DEFAULT_MIDI_TICK_DURATION;
   state = 0;
}

Midi_Timer::~Midi_Timer()
{
}

int Midi_Timer::Initialize()
{
   SDL_Init( SDL_INIT_TIMER);
   return 0;
}


void Midi_Timer::SetMidiTickDuration( unsigned int midi_tick_duration)
{
   Pause();
   this->midi_tick_duration = midi_tick_duration;
   Play();
}
   
void Midi_Timer::Start() // and play
{
   time_in_usec = 0;
   time_in_midi_ticks = 0;
   state = 0;
   Play();
}

void Midi_Timer::Play()
{
   if ( state == 0 )
     {
	last_usec = SDL_GetTicks()*1000;
	state = 1;
     }
}

void Midi_Timer::Pause()
{
   if ( state == 1)
     {
	unsigned int current_usec = SDL_GetTicks()*1000;
        time_in_usec += current_usec - last_usec;
	time_in_midi_ticks += ( current_usec - last_usec ) / midi_tick_duration;
	state = 0;
     }
}

unsigned int Midi_Timer::GetUSec()
{
   if ( state == 0 ) // paused
     {
	return time_in_usec;
     }
   else // playing
     {
	return time_in_usec + SDL_GetTicks()*1000 - last_usec;
     }
}

unsigned int Midi_Timer::GetMidiTicks()
{
   if ( state == 0 ) // paused
     {
	return time_in_midi_ticks;
     }
   else // playing
     {
	return time_in_midi_ticks + ( SDL_GetTicks()*1000 - last_usec ) / midi_tick_duration;
     }
}

void Midi_Timer::WaitUntilUsec( unsigned int usec)
{
   unsigned int current_usec = GetUSec();
     
   if ( usec > current_usec )
     {
	SDL_Delay( (usec-current_usec)/1000);
     }
}

void Midi_Timer::WaitUntilMidiTick( unsigned int midi_tick)
{
   unsigned int current_midi_tick = GetMidiTicks();
   
   // fprintf( stderr, "Midi_timer:: curent_midi_tick=%d waiting %d (untile %d)\n", current_midi_tick, (midi_tick-current_midi_tick)*midi_tick_duration, midi_tick);
   if ( midi_tick > current_midi_tick )
     {
	SDL_Delay( (midi_tick-current_midi_tick)*midi_tick_duration/1000);
     }
}

   