#ifndef _MIDI_SEQUENCER_HPP
#define _MIDI_SEQUENCER_HPP

class Midi_Device;
class Midi_Timer;
class Midi_File;
class Midi_Event;
class Midi_Lyric;
class DisplayManager;

typedef enum Midi_Sequencer_State{
   UNINITIALIZED,
   PLAY,
   PAUSE,
   STOP
};

class Midi_Sequencer
{
 public:
   Midi_Sequencer();
   ~Midi_Sequencer();
   int Initialize( Midi_Device *device);
   int SetDisplay( char *display_name);
   
   int LoadFromFile( char* filename);
   void Unload();
   
   void Play();
   void Pause();
   void Stop();

   void ModifTempo( double x); // x must be between

 private:
   void ProcessEvent( Midi_Event *event); 
   Midi_Device *device;
   DisplayManager *display_manager;
   Midi_File *file;
   Midi_Lyric *lyrics;
   Midi_Timer *timer;
   Midi_Sequencer_State state;
};

#endif
