#ifndef _MIDI_LYRIC_HPP
#define _MIDI_LYRIC_HPP

#include <vector>

using namespace std;

#define DEFAULT_MAX_LINE_WIDTH 256

class Midi_File;

class Midi_Lyric_Line
{
 public:
   // To construct a line, nb_characters MUST be >= 1
   Midi_Lyric_Line( char* characters, unsigned int *times, unsigned int nb_characters);
   ~Midi_Lyric_Line();

   inline unsigned int GetStartingTime() {return times[0];} 
   inline unsigned int GetEndingTime() {return times[nb_characters-1];}

   // Return the position of the first character after current_time
   unsigned int GetSeparation( unsigned int current_time);
   
   unsigned int nb_characters;
   char *characters;
   unsigned int *times;
   unsigned int starting_time;
   unsigned int ending_time; 
};

class Midi_Lyric
{
 public:
   Midi_Lyric( Midi_File* midi_file, unsigned int max_line_width=DEFAULT_MAX_LINE_WIDTH);
   ~Midi_Lyric();
   
   inline unsigned int GetNbLines() {return lines.size();} 
   inline Midi_Lyric_Line *GetLine( unsigned int l){return l<lines.size()?lines[l]:NULL;}
      
   void Print();
   void Print2();
   
 private:
   vector<Midi_Lyric_Line*> lines; 
};

#endif
