#include "midi_lyric.hpp"
#include "midi_file.hpp"
#include "midi_event.hpp"
#include <string.h>
#include <SDL_timer.h> // for Midi_Lyric::Print2() method

Midi_Lyric_Line::Midi_Lyric_Line( char* characters, unsigned int *times, unsigned int nb_characters)
{
   this->characters = new char[nb_characters+1];
   this->times = new unsigned int[nb_characters];
   this->nb_characters = nb_characters;
   
   for(unsigned int c=0;c<nb_characters;c++)
     {
	this->characters[c] = characters[c];
	this->times[c] = times[c];
     }
   this->characters[nb_characters] = '\0'; // usefull for printf
}

Midi_Lyric_Line::~Midi_Lyric_Line()
{
   delete characters;
   delete times;
}

unsigned int Midi_Lyric_Line::GetSeparation( unsigned int current_time)
{
   unsigned int separation = 0;
   
   // I could have done dichotomic find but nb_characters is small
   // enought and time is not critical here
   	
   while( separation < nb_characters && current_time > times[separation]) 
     separation++;
   
   //fprintf( stdout, "separation=%u\n", separation);
   return separation;
}


Midi_Lyric::Midi_Lyric( Midi_File* mf, unsigned int line_max_width)
{
   
   // max_line_width must be at least 1
   if ( line_max_width < 1 )
     line_max_width = 1;

   // init tmp_line
   char *tmp_line = new char[line_max_width+1];
   unsigned int *tmp_times = new unsigned int[line_max_width];
   int position_in_tmp_line = 0;
   
   // to trace positions in tracks
   unsigned int *current_pos_in_tracks = new unsigned int[mf->GetNbTracks()];
   for(unsigned int t=0;t<mf->GetNbTracks();t++)
     current_pos_in_tracks[t] = 0 ;
   
   unsigned int last_time = 0;
   bool parse_completed = false;
   
   while( !parse_completed) 
     {	
	// on cherche le prochain event dans tous les tracks au cas ou 
	// les event MIDI_TEXT ou MIDI_LYRIC pourraient etre dans tous 
	// les tracks bien qu'ils paraissent etre toujours dans le premier
	// peut etre que c'est specifie dans une doc ???
       	
	unsigned int next_event_minus_time = (unsigned int)-1; // max value
	int next_event_is_from_track = -1;
	
	for(unsigned int t=0;t<mf->GetNbTracks()-1;t++) 
	  {
	     if ( current_pos_in_tracks[t] >= mf->tracks[t].size()) // si ce track est termine on passe au suivant
	       continue;
	     
	     if ( mf->tracks[t][current_pos_in_tracks[t]]->absolute_time < next_event_minus_time) 
	       {
		  // on a trouve un event plus proche
		  
		  next_event_minus_time = mf->tracks[t][current_pos_in_tracks[t]]->absolute_time; 
		  next_event_is_from_track = t;
	       }
	  }
	
	if ( next_event_is_from_track != -1)
	  {
	     // mainteant qu'on l'a trouve voyons si c'est des paroles...
	    
	     Midi_Event* e = mf->tracks[next_event_is_from_track][current_pos_in_tracks[next_event_is_from_track]];
	     
	     if ( e->type == Midi_Event::META && ( e->metaEventCode == MIDI_TEXT_EVENT || e->metaEventCode == MIDI_LYRIC))
	       {
		  // Oui, alors on ajoute le texte
		   
		  for(int c=0;c<e->messageLength;c++)
		    {
		       if ( e->metaMessage[c] == '\\' || e->metaMessage[c] == '/' ) // nouvelle ligne
			 {
			    //fprintf( stderr, "alloc1 %d\n", position_in_tmp_line);
			    if ( tmp_line[0] != '@' /*&& tmp_line[0] != '%'*/)
			      lines.push_back( new Midi_Lyric_Line( tmp_line, tmp_times, position_in_tmp_line));
			    tmp_line[position_in_tmp_line]='\0';
			    //fprintf( stderr, "alloc2 -> %s\n", tmp_line);
			    position_in_tmp_line = 0;
			 }
		       else
			 {   
			    tmp_line[position_in_tmp_line] = e->metaMessage[c];
			    tmp_times[position_in_tmp_line] = e->absolute_time;
			    position_in_tmp_line++;
			 }
		    }  
	       }		  
	     current_pos_in_tracks[next_event_is_from_track] += 1;
	     last_time = e->absolute_time;
	  }
	else
	  {
	     // s'il n'y en a pas, la chanson est terminee...
	     parse_completed = true;
	     fprintf( stdout, "Midi_Lyric: prse completed\n");
	  }
     }
}

Midi_Lyric::~Midi_Lyric()
{
}

void Midi_Lyric::Print()
{
   
   for(unsigned int l=0;l<lines.size();l++)
     { 
	fprintf( stdout, "%d (%d) -> %s\n", l, lines[l]->times[0], lines[l]->characters);
     }
  
   Print2();
}

void Midi_Lyric::Print2()
{
   unsigned int current_line = 0 ;
   unsigned int starting_time = SDL_GetTicks();
   char tmp[1024];
   
   
   bool end=false;
   
   while( !end)
     {
	unsigned int current_time = SDL_GetTicks() - starting_time;
	current_time/=1;
	
	// 1) teste si on est toujours sur la bonne ligne
	current_line = 0 ;
	while( current_time > lines[current_line]->GetEndingTime() && current_line<lines.size()-1)
	  current_line++;
	
	// 2) affiche cette ligne
	strcpy( tmp, lines[current_line]->characters);
	tmp[lines[current_line]->GetSeparation(current_time)] = '|'; 
	
	fprintf( stdout, "\r[%d] %u (%u - %u) -> %s", current_time, current_line, lines[current_line]->GetStartingTime(), lines[current_line]->GetEndingTime(), tmp);
	fflush( stdout);
	
	SDL_Delay(100); // wait 10ms eg refresh time
	
	if ( current_line >= lines.size()-1)
	  end = true; 
     }
}
