#ifndef _MIDI_FILE_HPP
#define _MIDI_FILE_HPP

#include <vector>
#include <SDL_endian.h>

using namespace std;

class Chunk_Header;
class Midi_Event;

typedef vector<Midi_Event*> vector_of_midi_events;
typedef vector<vector_of_midi_events> vector_of_tracks;

class Midi_File
{
 public:
   Midi_File();
   ~Midi_File();
   void Load( char *filename);
   
   inline const unsigned int GetNbTracks() { return nb_tracks;}
   inline const unsigned int GetNbDivisions() { return division;}
 
   
// private:
   short format;
   short nb_tracks;
   short division; // the amount a quarter of note is divided into
   
   vector_of_tracks tracks; 
   
   // methods to make parsing easier
   unsigned long ReadLong();
   unsigned short ReadShort();
   unsigned char ReadByte();
   unsigned long ReadVariableLength();
   Chunk_Header *ReadChunkHeader();
   Midi_Event *ReadEvent();
   SDL_RWops *f;
   unsigned long last_time; // used by ReadEvent to compute absolute_time from delta_time
};

#endif
