#ifndef _MIDI_EVENT_HPP
#define _MIDI_EVENT_HPP

// MIDI messages
#define MIDI_NOTE_OFF               0x80
#define MIDI_NOTE_ON                0x90
#define MIDI_POLY_AFTERTOUCH        0xA0
#define MIDI_CTRL_CHANGE            0xB0
#define MIDI_PROG_CHANGE            0xC0
#define MIDI_CHNL_AFTERTOUCH        0xD0
#define MIDI_PITCH_BEND             0xE0

// channel mode
#define MIDI_SELECT_CHNL_MODE       0xB0

// system messages
#define MIDI_SYSTEM_EXCLUSIVE       0xF0
#define MIDI_TC_QUARTER_FRAME       0xF1
#define MIDI_SONG_POSITION_PTR      0xF2
#define MIDI_SONG_SELECT            0xF3
#define MIDI_TUNE_REQUEST           0xF6
#define MIDI_END_OF_EXCLUSIVE       0xF7

#define MIDI_TIMING_CLOCK           0xF8
#define MIDI_START                  0xFA
#define MIDI_CONTINUE               0xFB
#define MIDI_STOP                   0xFC
#define MIDI_ACTIVE_SENSING         0xFE
#define MIDI_SYSTEM_RESET           0xFF

  
// Midi Event Code for META Event
#define MIDI_FILE_META_EVENT        0xFF

// META Event Codes
#define MIDI_SEQUENCE_NUMBER        0x00
#define MIDI_TEXT_EVENT             0x01
#define MIDI_COPYRIGHT_NOTICE       0x02
#define MIDI_TRACK_NAME             0x03
#define MIDI_INSTRUMENT_NAME        0x04
#define MIDI_LYRIC                  0x05
#define MIDI_TEXT_MARKER            0x06
#define MIDI_CUE_POINT              0x07
#define MIDI_CHANNEL_PREFIX         0x20

// There is contention over what 0x21 really means.
// It's either a miswritten CHANNEL PREFIX or it's
// a non-standard PORT MAPPING used by a sequencer.
// Either way we include it (and generally ignore it)
// as it's a part of many MIDI files that already 
// exist.
#define MIDI_CHANNEL_PREFIX_OR_PORT 0x21

#define MIDI_END_OF_TRACK           0x2F
#define MIDI_SET_TEMPO              0x51
#define MIDI_SMPTE_OFFSET           0x54
#define MIDI_TIME_SIGNATURE         0x58
#define MIDI_KEY_SIGNATURE          0x59
#define MIDI_SEQUENCER_SPECIFIC     0x7F

// Some controllers
//
#define MIDI_CONTROLLER_BANK_MSB      0x00
#define MIDI_CONTROLLER_VOLUME        0x07
#define MIDI_CONTROLLER_BANK_LSB      0x20
#define MIDI_CONTROLLER_MODULATION    0x01
#define MIDI_CONTROLLER_PAN           0x0A
#define MIDI_CONTROLLER_SUSTAIN       0x40
#define MIDI_CONTROLLER_RESONANCE     0x47
#define MIDI_CONTROLLER_RELEASE       0x48
#define MIDI_CONTROLLER_ATTACK        0x49
#define MIDI_CONTROLLER_FILTER        0x4A
#define MIDI_CONTROLLER_REVERB        0x5B
#define MIDI_CONTROLLER_CHORUS        0x5D
#define MIDI_CONTROLLER_SOUNDS_OFF    0x78
#define MIDI_CONTROLLER_RESET         0x79 // reset all controllers
#define MIDI_CONTROLLER_LOCAL         0x7A // 0 off, 127 on
#define MIDI_CONTROLLER_ALL_NOTES_OFF 0x7B

// mask for eventCode 
#define MIDI_STATUS_BYTE_MASK       0x80
#define MIDI_MESSAGE_TYPE_MASK      0xF0
#define MIDI_CHANNEL_NUM_MASK       0x0F

// MIDI percussion channel
#define MIDI_PERCUSSION_CHANNEL     9

class Midi_Event
{
 public:
   typedef enum _type{
      MIDI,
      SYSEX,
      META
   };
   
   Midi_Event();
   ~Midi_Event();
   
   void print();
   
   _type type;
   int eventCode;
   int metaEventCode;
   int messageLength;
   char *metaMessage;
   unsigned long delta_time;
   unsigned long absolute_time;

   char data1;
   char data2;
   
 private:
      
};

bool operator < (const Midi_Event &event1, const Midi_Event &event2);

bool operator > (const Midi_Event &event1, const Midi_Event &event2);


#endif
