#include "midi_event.hpp"
#include <iostream.h>
#include <string.h>

#define MIDI_MESSAGE_TYPE_MASK 0xF0

Midi_Event::Midi_Event()
{
   delta_time = 0;
}

Midi_Event::~Midi_Event()
{
}

void Midi_Event::print()
{
   cout << "delta_time " << delta_time << " absolute_time " << absolute_time << " ";
   if ( type == META)
     {
	switch( metaEventCode)
	  {
	   case MIDI_SEQUENCE_NUMBER:
	     cout << "MIDI SEQUENCE NUMBER" << endl;
	     break;
	     
	   case MIDI_TEXT_EVENT:
	     char tmp[1024];
	     strncpy( tmp, metaMessage, messageLength);
	     tmp[messageLength]='\0';
	     cout << "MIDI TEXT:\t\"" << tmp << "\"" << endl;
	     
	     break;
	     
	   case MIDI_COPYRIGHT_NOTICE:
	     cout << "COPYRIGHT:\t\"" << metaMessage << "\"" << endl;
	     
	   case MIDI_TRACK_NAME:
	     cout << "TRACK NAME:\t\"" << metaMessage << "\"" << endl;
	     break;    
	     
	   case MIDI_INSTRUMENT_NAME:
	     cout << "INSTRUMENT NAME:\t\"" << metaMessage << "\"" << endl;
	     break;
	     
	   case MIDI_LYRIC:
	     cout << "LYRIC:\t\"" << metaMessage << "\"" << endl;
	     break;
	     
	   case MIDI_TEXT_MARKER:
	     cout << "MARKER:\t\"" << metaMessage << "\"" << endl;
	     break;
	     
	   case MIDI_CUE_POINT:
	     cout << "CUE POINT:\t\"" << metaMessage << "\"" << endl;
	     break;
	     
	     // Sets a Channel number for a TRACK before it starts
/*	   case MIDI_CHANNEL_PREFIX:
	     cout << "CHANNEL PREFIX:\t"
	       << (Rosegarden::timeT)m_metaMessage[0]
	       << endl;
	     break;
	     
	     // These are actually the same case but this is not an
	     // official META event - it just crops up a lot.  We
	     // assume it's a MIDI_CHANNEL_PREFIX though
	     //
	   case MIDI_CHANNEL_PREFIX_OR_PORT:
	     cout << "FIXED CHANNEL PREFIX:\t"
	       << (Rosegarden::timeT)m_metaMessage[0] << endl;
	     break;
*/	     
	   case MIDI_END_OF_TRACK:
	     cout << "END OF TRACK" << endl;
	     break;
/*	     
	   case MIDI_SET_TEMPO:
	     tempo =
	       ((Rosegarden::timeT)(((MidiByte)m_metaMessage[0]) << 16))+
	       ((Rosegarden::timeT)(((MidiByte)m_metaMessage[1]) << 8))+
	       (short)(MidiByte)m_metaMessage[2]; 
	     
	     tempo = 60000000/tempo;
	     cout << "SET TEMPO:\t" << tempo << endl;
	     break;
	     
	   case MIDI_SMPTE_OFFSET:
	     cout << "SMPTE TIME CODE:\t"
	       << (Rosegarden::timeT)m_metaMessage[0]
	       << ":" << (Rosegarden::timeT)m_metaMessage[1]
	       << ":" << (Rosegarden::timeT)m_metaMessage[2]
	       << "  -  fps = " << (Rosegarden::timeT)m_metaMessage[3]
	       << "  - subdivsperframe = "
	       << (Rosegarden::timeT)m_metaMessage[4] 
	       << endl;
	     break;
	     
	   case MIDI_TIME_SIGNATURE:
	     cout << "TIME SIGNATURE:\t"
	       << (Rosegarden::timeT)m_metaMessage[0]
	       << "/"
	       << (1 << (Rosegarden::timeT)m_metaMessage[1]) << endl;
	     break;
	     
	   case MIDI_KEY_SIGNATURE:
	     tonality = (int)m_metaMessage[0];
	     
	     if (tonality < 0)
	       {
		  sharpflat = -tonality + " flat";
	       }
	     else
	       {
		  sharpflat = tonality;
		  sharpflat +=  " sharp";
	       }
	  
	     cout << "KEY SIGNATURE:\t" << sharpflat << " "
	       << (((int)m_metaMessage[1]) == 0 ? "major" : "minor")
		 << endl;
	     
	     break;
*/	     
	   case MIDI_SEQUENCER_SPECIFIC:
	     cout << "SEQUENCER SPECIFIC:\t\"" << metaMessage << endl;
	     break;
	     	     
	   default:
	     cout << "Unknown MIDI META event - "
	       << metaEventCode << endl;
	     break;
	  }
     }
   else // the rest
     {
	switch( eventCode & MIDI_MESSAGE_TYPE_MASK)
	  {
	   case MIDI_NOTE_ON:
	     cout << "NOTE ON:\t" << (int)data1 << " - "
	       << (int)data2 << endl;
	     break;
	     
	   case MIDI_NOTE_OFF:
	     cout << "NOTE OFF:\t" << (int)data1 << " - "
	       << (int)data2 << endl;
	     break;
	     
	   case MIDI_POLY_AFTERTOUCH:
	     cout << "POLY AFTERTOUCH:\t" << (int)data1
	       << " - " << (int)data2 << endl;
	     break;
	     
	   case MIDI_CTRL_CHANGE:
	     cout << "CTRL CHANGE:\t" << (int)data1
	       << " - " << (int)data2 << endl;
	     break;
	     
	   case MIDI_PITCH_BEND:
	     cout << "PITCH BEND:\t" << (int)data1
	       << " - " << (int)data2 << endl;
	     break;
		  
	   case MIDI_PROG_CHANGE:
	     cout << "PROG CHANGE:\t" << (int)data1 << endl;
	     break;
	     
	   case MIDI_CHNL_AFTERTOUCH:
	     cout << "CHNL AFTERTOUCH\t" << (int)data1 << endl;
	     break;
		  
	   default:
	     cout << "Undefined MIDI event" << endl;
	     break;
	  }
     }

   return;
}


bool operator < (const Midi_Event &event1, const Midi_Event &event2)
{ return event1.delta_time < event2.delta_time; }

bool operator > (const Midi_Event &event1, const Midi_Event &event2)
{ return event1.delta_time > event2.delta_time; }
