#include "midi_device_oss.hpp"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/param.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>
#include "midi_event.hpp"

Midi_Device_OSS::Midi_Device_OSS()
{
   seqfd = -1;
}

Midi_Device_OSS::~Midi_Device_OSS()
{
   CloseDevice();
}

void Midi_Device_OSS::Initilize()
{
   OpenDevice();
}

int Midi_Device_OSS::OpenDevice()
{
   seqfd = open( "/dev/sequencer", O_WRONLY | O_NONBLOCK, 0);
   
   if (seqfd==-1)
     {
	fprintf( stderr, "Midi_Device_OSS::OpenDevice: can't open device /dev/sequencer\n");
	return -1;
     }
   
   ioctl( seqfd, SNDCTL_SEQ_RESET);
   
   ioctl( seqfd, SNDCTL_SEQ_NRSYNTHS, &nb_devices);
   ioctl( seqfd, SNDCTL_SEQ_NRMIDIS, &nb_midi_ports);
   
   midi_info midiinfo;
   midiinfo.device=device;
   
#ifdef MIDIOUTDEBUG
   fprintf( stdout, "Number of synth devices : %d\n",ndevs);
   fprintf( stdout, "Number of midi ports : %d\n",nmidiports);
   fprintf( stdout, "Rate : %d\n",rate);
   
   int i;
   synth_info synthinfo;
   for (i=0;i<ndevs;i++)
     {
	synthinfo.device=i;
	if (ioctl(seqfd,SNDCTL_SYNTH_INFO,&synthinfo)!=-1)
	  {
	     printfdebug("----");
	     printfdebug("Device : %d\n",i);
	     printfdebug("Name : %s\n",synthinfo.name);
	     switch (synthinfo.synth_type)
	       {
		case (SYNTH_TYPE_FM) : printfdebug("FM\n");break;
		case (SYNTH_TYPE_SAMPLE) : printfdebug("Sample\n");break;
		case (SYNTH_TYPE_MIDI) : printfdebug("Midi\n");break;
		default : printfdebug("default type\n");break;
	       }
	     switch (synthinfo.synth_subtype)
	       {
		case (FM_TYPE_ADLIB) : printfdebug("Adlib\n");break;
		case (FM_TYPE_OPL3) : printfdebug("Opl3\n");break;
		case (MIDI_TYPE_MPU401) : printfdebug("Mpu-401\n");break;
		case (SAMPLE_TYPE_GUS) : printfdebug("Gus\n");break;
		default : printfdebug("default subtype\n");break;
	       }
	  }
     }
   
   for (i=0;i<nmidiports;i++)
     {
	midiinfo.device=i;
	if (ioctl(seqfd,SNDCTL_MIDI_INFO,&midiinfo)!=-1)
	  {
	     printfdebug("----");
	     printfdebug("Device : %d\n",i);
	     printfdebug("Name : %s\n",midiinfo.name);
	     printfdebug("Device type : %d\n",midiinfo.dev_type);
	  }
     }
   
#endif
   
   
   count=0.0;
   lastcount=0.0;
   if ( nb_midi_ports <= 0)
     {
	fprintf( stderr, "Midi_Device_OSS::OpenDevice: there is no midi port !\n");
	return -1;
     }

   return 1;
}

void Midi_Device_OSS::CloseDevice()
{   
   if ( seqfd >= 0) 
     close( seqfd);
   seqfd = -1;
}

/*
void MidiOut::ResetDevice()
{
   int chn;

   uunsigned char gm_reset[5]={0x7e, 0x7f, 0x09, 0x01, 0xf7};
   sysex(gm_reset, sizeof(gm_reset));
   
   for (chn=0;chn<16;chn++)
     {
	chnmute[chn]=0;
	chnPatchChange(chn,0);
	chnPressure(chn,127);
	chnPitchBender(chn, 0x00, 0x40);
	chnController(chn, CTL_MAIN_VOLUME,110*volumepercentage);
	chnController(chn, CTL_EXT_EFF_DEPTH, 0);
	chnController(chn, CTL_CHORUS_DEPTH, 0);
	chnController(chn, 0x4a, 127);
     }
 }*/

void Midi_Device_OSS::SendEvent( Midi_Event *event)
{
   if ( event->type == Midi_Event::MIDI)
     {
	switch( event->eventCode)
	  {  
	     /*	   case MIDI_NOTE_ON:  
	     SEQ_MIDIOUT( device, MIDI_NOTEON + event->data1);
	     SEQ_MIDIOUT( device, map->key(chn,chnpatch[chn],note));
	     SEQ_MIDIOUT( device, event->data2); // velocity
	     break;
	   
	   case MIDI_NOTE_OFF:
	     SEQ_MIDIOUT(device, MIDI_NOTEOFF + map->channel(chn));
	     SEQ_MIDIOUT(device, map->key(chn,chnpatch[chn],note));
	     SEQ_MIDIOUT(device, event->data2); // velocity
	     break;
	     
	   case MIDI_POLY_AFTER_TOUCH: //TODO: verifier
	     SEQ_MIDIOUT(device, MIDI_KEY_PRESSURE + map->channel(chn));
	     SEQ_MIDIOUT(device, map->key(chn,chnpatch[chn],note));
	     SEQ_MIDIOUT(device, vel);
	     break;
	     
	   case chnPatchChange:
	     SEQ_MIDIOUT(device, MIDI_PGM_CHANGE + map->channel(chn));
	     SEQ_MIDIOUT(device, map->patch(chn,patch));
	     chnpatch[chn]=patch;
	     break;
	     
	   case chnPressure:
	     SEQ_MIDIOUT(device, MIDI_CHN_PRESSURE + map->channel(chn));
	     SEQ_MIDIOUT(device, vel);  
	     chnpressure[chn]=vel;
	     break;

	   case chnPitchBender:
	     SEQ_MIDIOUT(device, MIDI_PITCH_BEND + map->channel(chn));
	     map->pitchBender(chn,lsb,msb);
	     SEQ_MIDIOUT(device, lsb);
	     SEQ_MIDIOUT(device, msb);
	     chnbender[chn]=(msb << 8) | (lsb & 0xFF);
	     break;
	     
	   case chnController:
	     SEQ_MIDIOUT(device, MIDI_CTL_CHANGE + map->channel(chn));
	     map->controller(chn,ctl,v);
	     if ((ctl==11)||(ctl==7))
	       {
		  v=(v*volumepercentage)/100;
		  if (v>127) v=127;
	       }
	     SEQ_MIDIOUT(device, ctl);
	     SEQ_MIDIOUT(device, v);
	     chncontroller[chn][ctl]=v;
	     break;
*/	     
	   default:;
	  }
     }
   else if ( event->type == Midi_Event::SYSEX)
     {
     }
}



/*
void MidiOut::sysex(uchar *data, ulong size)
{
  ulong i=0;
  SEQ_MIDIOUT(device, MIDI_SYSTEM_PREFIX);
  while (i<size)
  {
    SEQ_MIDIOUT(device, *data);
    data++;
    i++;
  }
#ifdef MIDIOUTDEBUG
  printfdebug("sysex\n");
#endif
}

void MidiOut::channelSilence (uchar chn)
{
  uchar i;
  for ( i=0; i<127; i++)
  {
    noteOff(chn,i,0);
  };
  SEQ_DUMPBUF();
}

void MidiOut::channelMute(uchar chn, int a)
{
  if (a==1)
  {
    chnmute[chn]=a;
    channelSilence(chn);
  }
  else if (a==0)
  {
    chnmute[chn]=a;
  }
  //  else ignore the call to this procedure 
}

void MidiOut::seqbuf_dump (void)
{
  if (_seqbufptr)
    if (write (seqfd, _seqbuf, _seqbufptr) == -1)
    {
      printfdebug("Error writing to /dev/sequencer in MidiOut::seq_buf_dump\n");
      perror ("write /dev/sequencer in seqBufDump\n");
      exit (-1);
    }
  _seqbufptr = 0;
}

void MidiOut::seqbuf_clean(void)
{
  _seqbufptr=0;
}

#ifdef HANDLETIMEINDEVICES
void MidiOut::wait(double ticks)
{
  SEQ_WAIT_TIME(((int)(ticks/convertrate)));
#ifdef MIDIOUTDEBUG
  printfdebug("Wait  >\t ticks: %g\n",ticks);
#endif
}

#ifdef MIDIOUTDEBUG
void MidiOut::tmrSetTempo(int v)
#else
void MidiOut::tmrSetTempo(int)
#endif
{
#ifdef MIDIOUTDEBUG
  printfdebug("SETTEMPO  >\t tempo: %d\n",v);
#endif

  //SEQ_SET_TEMPO(v);
  //SEQ_DUMPBUF();
}

void MidiOut::sync(int i)
{
#ifdef MIDIOUTDEBUG
  printfdebug("Sync %d\n",i);
#endif
  if (i==1) 
  {    
    seqbuf_clean();
    // If you have any problem, try removing the next 2 lines, 
    //   I though they would be useful here, but I don't know
    //   what they exactly do :-) 
    ioctl(seqfd,SNDCTL_SEQ_RESET);
    ioctl(seqfd,SNDCTL_SEQ_PANIC);
  }
  ioctl(seqfd, SNDCTL_SEQ_SYNC);
}

void MidiOut::tmrStart(void)
{
  SEQ_START_TIMER();
  SEQ_DUMPBUF();
}

void MidiOut::tmrStop(void)
{
  SEQ_STOP_TIMER();
  SEQ_DUMPBUF();
}

void MidiOut::tmrContinue(void)
{
  SEQ_CONTINUE_TIMER();
  SEQ_DUMPBUF();
}

#endif

char *MidiOut::midiMapFilename(void)
{
  return (map!=NULL) ? map->filename() : (char *)"";
}

const char * MidiOut::deviceName(void) const
{
  switch (deviceType())
  {
    case (KMID_EXTERNAL_MIDI) : return "External Midi";
    case (KMID_SYNTH) : return "Synth";
    case (KMID_FM) : return "FM";
    case (KMID_GUS) : return "GUS";
    case (KMID_AWE) : return "AWE";
  }
  return "Unknown";
}




/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////


int Midi_Device_OSS::Initilization()
{
   
   seqfd = open("/dev/sequencer", O_WRONLY | O_NONBLOCK, 0);
   
   if ( seqfd == -1)
     {
	fprintf( stderr, "Midi_Device_OSS: can't open /dev/sequencer to get some information\n");
	return -1;
     };
   
   nb_synths = 0;
   nb_midi = 0;
   ioctl( seqfd, SNDCTL_SEQ_NRSYNTHS, &n_synths);
   ioctl( seqfd, SNDCTL_SEQ_NRMIDIS, &n_midi);
   nb_total = nb_midi + nb_synths;
   
   if (nb_midi == 0) 
     {
	fprintf( stderr, "Midi_Device_OSS: there's no midi port\n");
	//This could be a problem if the user don't have a synth neither,
	// but not having any of both things is unusual 
	//    _ok=0;
	//    return 1;
     }
   
   device=new MidiOut*[n_total];
   midiinfo=new midi_info[n_midi];
   synthinfo=new synth_info[n_synths];
   
   int i;
   for (i=0;i<n_midi;i++)
     {
	midiinfo[i].device=i;
	if (ioctl(seqfd,SNDCTL_MIDI_INFO,&midiinfo[i])!=-1)
	  {
#ifdef GENERAL_DEBUG_MESSAGES
	     printf("----\n");
	     printf("Device : %d\n",i);
	     printf("Name : %s\n",midiinfo[i].name);
	     printf("Device type : %d\n",midiinfo[i].dev_type);
#endif
	  }
    device[i]=new MidiOut(i);
     }
   
   for (i=0;i<n_synths;i++)
     {
	synthinfo[i].device=i;
	if (ioctl(seqfd,SNDCTL_SYNTH_INFO,&synthinfo[i])!=-1)
	  {
#ifdef GENERAL_DEBUG_MESSAGES  
	     printf("----\n");
	     printf("Device : %d\n",i);
	     printf("Name : %s\n",synthinfo[i].name);
	     switch (synthinfo[i].synth_type)
	       {
		case (SYNTH_TYPE_FM) : printf("FM\n");break;
		case (SYNTH_TYPE_SAMPLE) : printf("Sample\n");break;
		case (SYNTH_TYPE_MIDI) : printf("Midi\n");break;
		default : printf("default type\n");break;
	       };
	     switch (synthinfo[i].synth_subtype)
	       {
		case (FM_TYPE_ADLIB) : printf("Adlib\n");break;
		case (FM_TYPE_OPL3) : printf("Opl3\n");break;
		case (MIDI_TYPE_MPU401) : printf("Mpu-401\n");break;
		case (SAMPLE_TYPE_GUS) : printf("Gus\n");break;
		default : printf("default subtype\n");break;
	       }
#endif
	     if (synthinfo[i].synth_type==SYNTH_TYPE_FM) 
	       device[i+n_midi]=new FMOut(i,synthinfo[i].nr_voices);
	     else if ((synthinfo[i].synth_type==SYNTH_TYPE_SAMPLE)&&
		      (synthinfo[i].synth_subtype==SAMPLE_TYPE_GUS))
	       device[i+n_midi]=new GUSOut(i,synthinfo[i].nr_voices);
	     else
	       device[i+n_midi]=new SynthOut(i);
	  }
  }
   
   close(seqfd);
   
   //#ifdef AT_HOME
   //MidiMapper *map=new MidiMapper("/opt/kde/share/apps/kmid/maps/yamaha790.map");
   //device[0]->useMapper(map);
   //#endif
   
   initialized=1;

   return 0;
}

void DeviceManager::openDev(void)
{
/////////////////////////
}

void DeviceManager::closeDev(void)
{
  if (seqfd==-1) return;
#ifndef HANDLETIMEINDEVICES
  tmrStop();
#endif
 */ /*
     DEBUGPRINTF("Closing devices : ");
     if (device!=NULL) for (int i=0;i<n_total;i++) 
     {
       device[i]->initDev();
       DEBUGPRINTF("%s ",device[i]->deviceName());

  //	device[i]->closeDev();
  };
  DEBUGPRINTF("\n");
   *//*
  close(seqfd);
  seqfd=-1;
}

void DeviceManager::initDev(void)
{
  if (device!=NULL) 
  {
    DEBUGPRINTF("Initializing devices :");
    for (int i=0;i<n_total;i++) 
    {
      device[i]->initDev();
      DEBUGPRINTF("%s ",device[i]->deviceName());
    }
    DEBUGPRINTF("\n");
  }
}
*/
