#ifndef _MIDI_DEVICE_ALSA_RAW_HPP
#define _MIDI_DEVICE_ALSA_RAW_HPP

// ALSA rawmidi implementation of the class Midi_Device

#include "midi_device.hpp"
#include <alsa/asoundlib.h>

class Midi_Device_Alsa_Raw: public Midi_Device
{
 public:
   Midi_Device_Alsa_Raw();
   virtual ~Midi_Device_Alsa_Raw();
   virtual void Initialize();
   virtual void SendEvent( Midi_Event* event);
   
 private:
   void OpenDevice();
   void CloseDevice();
   void WriteByte( unsigned char byte);
   void Flush();
   int mode;
   char *device_out;
   char *node_out;
   int fd_out;
   snd_rawmidi_t *handle_out;   
};

#endif
