#ifdef _HAVE_ALSA

#include "midi_device_alsa_raw.hpp"
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <alsa/asoundlib.h>
#include "midi_event.hpp"

#define MODE_NOT_INITIALIZED 0
#define MODE_NODE            1
#define MODE_DEVICE          2

#define DEFAULT_NODE         "hw:0,0"
#define DEFAULT_DEVICE       "/dev/midi"

Midi_Device_Alsa_Raw::Midi_Device_Alsa_Raw()
{
   device_out = DEFAULT_NODE;
   node_out = DEFAULT_DEVICE;
   fd_out = -1;
   handle_out = 0;
   mode = MODE_NOT_INITIALIZED;
}

Midi_Device_Alsa_Raw::~Midi_Device_Alsa_Raw()
{
   CloseDevice();
}

void Midi_Device_Alsa_Raw::Initialize()
{
   OpenDevice();
}

void Midi_Device_Alsa_Raw::OpenDevice()
{   
   if ( mode != MODE_NOT_INITIALIZED )
     return;
   
   int err = snd_rawmidi_open( NULL, &handle_out, device_out, 0);
   if ( err == 0 ) 
     {
	mode = MODE_NODE;
	fprintf( stdout, "Midi_Device_Alsa_Raw::Initialize: all right in node mode\n");
	return;
     }
   else
     {
	fprintf( stderr,"Midi_Device_Alsa_Raw::Initialize: snd_rawmidi_open %s failed: %d\n", device_out,err);
     }
   
   fd_out = open(node_out,O_WRONLY);		
   if ( fd_out >= 0) 
     {
	mode = MODE_DEVICE;
	fprintf( stdout, "Midi_Device_Alsa_Raw::Initialize: all right in device mode\n");
	return;
     }
   else
     {	
	fprintf( stderr,"Midi_Device_Alsa_Raw::Initialize: open %s for output failed\n",node_out);		
     }  
}

void Midi_Device_Alsa_Raw::SendEvent( Midi_Event *event)
{   
   if ( event->type == Midi_Event::MIDI)
     {
	switch( event->eventCode & MIDI_MESSAGE_TYPE_MASK)
	  {
	   case MIDI_NOTE_ON:
	   case MIDI_NOTE_OFF:
	   case MIDI_POLY_AFTERTOUCH:
	   case MIDI_CTRL_CHANGE:
	   case MIDI_PITCH_BEND:
	     
	     WriteByte( event->eventCode);
	     WriteByte( event->data1);
	     WriteByte( event->data2);
	     Flush();
	     break;
	     
	   case MIDI_PROG_CHANGE:
	   case MIDI_CHNL_AFTERTOUCH:
	     
	     WriteByte( event->eventCode);
	     WriteByte( event->data1);
	     Flush();
	     break;
	         
	   default:
	     fprintf( stderr, "Midi_Device_Alsa_Raw::SendEvent: unsupported Midi event code: %d\n", event->eventCode); 
 
	     return;
	     break;
	  }
     }
   else if ( event->type == Midi_Event::SYSEX)
     {	
	fprintf( stderr, "OULALA les SYSEX je suis pas trop sur\n");
	WriteByte( event->eventCode);
	WriteByte( event->messageLength);
	for( int i=0;i<event->messageLength;i++)
	  WriteByte( event->metaMessage[i]);
	//WriteByte( );
	Flush();
     }
}

void Midi_Device_Alsa_Raw::WriteByte( unsigned char byte)
{
   if ( mode == MODE_NODE)
     snd_rawmidi_write( handle_out, &byte, 1);
   else if ( mode == MODE_DEVICE)
     write( fd_out, &byte, 1);   
}

void Midi_Device_Alsa_Raw::Flush()
{
   if ( mode == MODE_NODE)
     snd_rawmidi_drain( handle_out);
}

void Midi_Device_Alsa_Raw::CloseDevice()
{
   if ( mode == MODE_NODE)
     {
	snd_rawmidi_drain(handle_out); 
	snd_rawmidi_close(handle_out);	
     }
   
   else if ( mode == MODE_DEVICE)
     {
	close(fd_out);
     }
   
   mode = MODE_NOT_INITIALIZED;
   
}

#endif // _HAVE_ALSA
