#ifndef _MIDI_DEVICE_ALSA_HPP
#define _MIDI_DEVICE_ALSA_HPP

// ALSA implementation of the class Midi_Device

#include "midi_device.hpp"
#include <alsa/asoundlib.h>

class Midi_Device_Alsa: public Midi_Device
{
 public:
   Midi_Device_Alsa();
   virtual ~Midi_Device_Alsa();
   virtual void Initialize();
   virtual void SendEvent( Midi_Event* event);

 private:
   snd_seq_t *handle;
   int client;
   int port;
   int queue;
   int maxClients;
   int maxPorts;
   int maxQueues;
   unsigned int player_starting_time;
};

#endif
