#include <stdlib.h>
#include <stdio.h>
#include <SDL_timer.h>
#include "midi_file.hpp"
#include "midi_device.hpp"
#include "midi_sequencer.hpp"
#include "midi_device_alsa_raw.hpp"
#include "midi_device_dummy.hpp"

int main( int argc, char **argv)
{
   char *midi_filename =  "test.mid";
   char *display_name = "display_gl.so";
   
   Midi_Sequencer *mseq = new Midi_Sequencer();
   
   mseq->Initialize( new Midi_Device_Alsa_Raw());

   if ( argc > 2)
     display_name = argv[2];
   
   mseq->SetDisplay( display_name);
   
   if ( argc > 1)
     midi_filename = argv[1];
   
   mseq->LoadFromFile( midi_filename);
   
   mseq->Play();

   delete mseq;
   
   fprintf( stderr, "A bientot\n");

   return EXIT_SUCCESS;
}
