#ifndef _GL_PAETICLES_HPP
#define _GL_PARTICLES_HPP

#include <GL/gl.h>

struct Particle;

struct Position
{
   float x;
   float y;
   float z;
   
   float xi;
   float yi;
   float zi;
   
   float time_left;
};


class Gl_Particles
{
 public:
   Gl_Particles( int nb_particles, char* texture);
   ~Gl_Particles();
   
   void SetDispersion( float d) {dispersion=d;}
   void SetSpeed( float s) {speed=s;}
   void SetShininess( float s) {shininess=s;}
   void SetMainDirection( float x, float y, float z) { start_speed_x=x;start_speed_y=y;start_speed_z=z;}
   void SetPosition( float x, float y, float z) { starting_position.x=x;starting_position.y=y;starting_position.z=z;}
   void MoveTo( float x, float y, float z, float dt_sec);
   
   void Reset();
   void Update( unsigned int dt);
   void Draw();
   
 private:
   void LaunchParticle( int no_particle);
   float speed;
   float dispersion;
   float shininess;
   float start_x;
   float start_y;
   float start_z;
   float start_speed_x;    
   float start_speed_y;
   float start_speed_z;
   float gravity_x;
   float gravity_y;
   float gravity_z;
   Position starting_position;
   Particle *particles;
   unsigned int nb_particles;
   GLuint texture;
};

#endif
