#include <stdlib.h>
#include <stdio.h>
#include <SDL.h>
#include "VSDL_ttf.h"
#include "display.hpp"
#include "midi_lyric.hpp"

#define FONT_FILE "arial.ttf"
SDL_Color c_white = { 0xFF, 0xFF, 0xFF, 0 };
SDL_Color c_black = { 0x00, 0x00, 0x00, 0 };
SDL_Color c_red =   { 0xFF, 0x00, 0x00, 0 };
SDL_Color c_yellow = { 0x00, 0xFF, 0xFF, 0 };

class Display_Sdl : public Display
{  
 public:
   Display_Sdl();
   virtual ~Display_Sdl();
   virtual void Initialize();
   virtual void Terminate(); 
   virtual void Refresh();
 
 private:
   void DisplayText( int x, int y, Midi_Lyric_Line *line);
   void DrawBackGround();
   unsigned int current_line;
   int line_state;
   // SDL stuff
   SDL_Surface *screen;
   TTF_Font *font;
};

Display_Sdl::Display_Sdl()
{
   state = UNINITIALIZED;
   current_line = 0;
   line_state = 0;
}

Display_Sdl::~Display_Sdl()
{
   if ( state == WORKING)
     Terminate();
}

void Display_Sdl::Initialize()
{  
   int videoFlags = SDL_ANYFORMAT;//|SDL_FULLSCREEN ;
   int width = 640;
   int height = 480;
   char *title = "KARAOKE_Display_Sdl";
   char *fontfile = FONT_FILE;
   
   // 1) Init SDL
   
   if ( SDL_Init(SDL_INIT_VIDEO) < 0 ) 
     {
	fprintf( stderr, "Display_Sdl::Initialize: can't init video!\n");
	return;
     }

   if ( ( screen = SDL_SetVideoMode( width, height, 0, videoFlags)) == NULL ) 
     {
	fprintf( stderr, "Display_Sdl::Initialize: can't set %dx%dxanybpp video mode: %s\n",
		 width, height, SDL_GetError());
	return;
     }
  
   SDL_WM_SetCaption( title, title) ;
    
   // 2) Load fonts
   
   VSDL_TTF_Init();
   
   font = VSDL_TTF_OpenFont( fontfile, 24);
      
   fprintf( stdout, "Display_Sdl::Initialize: Sucessfull (mode set to %dx%d at %d bpp)\n", screen->w, screen->h, (int)screen->format->BitsPerPixel) ;

   state = WORKING;
}

void Display_Sdl::Terminate()
{
   state = UNINITIALIZED;
}

void Display_Sdl::Refresh()
{
   if ( state != WORKING || !lyrics_ready)
     return;
      
   // find the new current_line
   
   if ( current_tick < this->current_tick) // we have moved backward
     {
	current_line = 0;
	line_state=0;
     }
   
   this->current_tick = current_tick;

   while( current_line<lyrics->GetNbLines() && current_tick > lyrics->GetLine(current_line)->GetEndingTime() )
     { 
	current_line++;
	line_state = ( line_state + 1 ) % 4;
     }

   // Draw everything

   DrawBackGround();
   
   switch( line_state)
     {
      case 0: // premiere ligne active 
	DisplayText( 0, 0, lyrics->GetLine(current_line));
	DisplayText( 0, 1, lyrics->GetLine(current_line+1));
	DisplayText( 0, 2, lyrics->GetLine(current_line+2));
	DisplayText( 0, 3, lyrics->GetLine(current_line+3));
	break;
      case 1: // seconde ligne active
	DisplayText( 0, 0, lyrics->GetLine(current_line-1));
	DisplayText( 0, 1, lyrics->GetLine(current_line));
	DisplayText( 0, 2, lyrics->GetLine(current_line+1));
	DisplayText( 0, 3, lyrics->GetLine(current_line+2));
	break;
      case 2: // troisieme ligne active
	DisplayText( 0, 0, lyrics->GetLine(current_line+2));
	DisplayText( 0, 1, lyrics->GetLine(current_line+3));
	DisplayText( 0, 2, lyrics->GetLine(current_line));
	DisplayText( 0, 3, lyrics->GetLine(current_line+1));
	break;
      case 3: // quatrieme ligne active
	DisplayText( 0, 0, lyrics->GetLine(current_line+1));
	DisplayText( 0, 1, lyrics->GetLine(current_line+2));
	DisplayText( 0, 2, lyrics->GetLine(current_line-1));
	DisplayText( 0, 3, lyrics->GetLine(current_line));
	break;
     }
   
   SDL_Flip( screen);
}

void Display_Sdl::DisplayText( int x, int y, Midi_Lyric_Line *line)
{
   float full_width;
   float width_colored_part = 0.;
   SDL_Rect bb;
   int w, h;
   
   if ( line == NULL)
     return;
   
   char tmp[1024];//TODO
     
   // display colored part

   int separation = line->GetSeparation( current_tick)+1;
   
   TTF_SizeText( font, line->characters, &w, &h);
   full_width = w;
   
   if ( separation > 0)
     {
	strncpy( tmp, line->characters, separation);
	tmp[separation] = '\0';
	VSDL_TTF_SetColor( c_red, c_black, font);
	VSDL_TTF_Write( screen, 320-full_width/2, y*32+32, tmp, font, VSDL_TTF_NORMAL, &bb);
	//width_colored_part = bb.w ;
	TTF_SizeText( font, tmp, &w, &h);
	width_colored_part = w;
/*	if ( tmp[separation-1] == ' ')
	  width_colored_part+=2;
	else
	  width_colored_part-=2;*/
     }
   
   // display uncolored part
   
   if ( separation < line->nb_characters)
     {
	strcpy( tmp, line->characters+separation);
	VSDL_TTF_SetColor( c_yellow, c_black, font);
	VSDL_TTF_Write( screen, 320-full_width/2+(int)width_colored_part, y*32+32, tmp, font, VSDL_TTF_NORMAL, &bb);
     }
}

void Display_Sdl::DrawBackGround()
{
   SDL_Rect rect ;
  
   rect.x = 0 ;
   rect.y = 0 ;
   rect.w = screen->w ;
   rect.h = screen->h ;
   SDL_FillRect( screen, &rect, 0) ;
}

Display_Sdl DYNAMIC_DISPLAY_SYMBOL;