#include <ncurses.h>
#include <SDL.h>
#include <SDL_timer.h>
#include "display.hpp"
#include "midi_lyric.hpp"

#define COLOR_SELECTED       COLOR_PAIR( 2) | A_BOLD
#define COLOR_NORMAL         COLOR_PAIR( 3)
#define INIT_COLOR_SELECTED  init_pair( 2, COLOR_RED, COLOR_BLACK) 
#define INIT_COLOR_NORMAL    init_pair( 3, COLOR_WHITE, COLOR_BLACK) 

class Display_Ncurses : public Display
{  
 public:
   Display_Ncurses();
   ~Display_Ncurses();
   void Initialize();
   void Terminate(); 
   void Refresh();
 
 private:
   void DisplayText( int x, int y, Midi_Lyric_Line *line);
   unsigned int current_line;
   int line_state;
};

Display_Ncurses::Display_Ncurses()
{
   state = UNINITIALIZED;
   current_line = 0;
   line_state = 0;
}

Display_Ncurses::~Display_Ncurses()
{
   if ( state == WORKING)
     Terminate();
}

void Display_Ncurses::Initialize()
{
   initscr();
   //cbreak();
   //noecho();
   //nonl();
   start_color();
   INIT_COLOR_NORMAL;
   INIT_COLOR_SELECTED;
   state = WORKING;
}

void Display_Ncurses::Terminate()
{
   state = UNINITIALIZED;
   endwin();
}

void Display_Ncurses::Refresh()
{
   if ( state != WORKING || !lyrics_ready)
     return;
      
   // find the new current_line
   
   if ( current_tick < this->current_tick) // we have moved backward
     {
	current_line = 0;
	line_state=0;
     }
   
   this->current_tick = current_tick;

   while( current_line<lyrics->GetNbLines() && current_tick > lyrics->GetLine(current_line)->GetEndingTime() )
     { 
	current_line++;
	line_state = ( line_state + 1 ) % 4;
     }
     
   erase();
   
   switch( line_state)
     {
      case 0: // premiere ligne active 
	DisplayText( 10, 5, lyrics->GetLine(current_line));
	DisplayText( 10, 6, lyrics->GetLine(current_line+1));
	DisplayText( 10, 7, lyrics->GetLine(current_line+2));
	DisplayText( 10, 8, lyrics->GetLine(current_line+3));
	break;
      case 1: // seconde ligne active
	DisplayText( 10, 5, lyrics->GetLine(current_line-1));
	DisplayText( 10, 6, lyrics->GetLine(current_line));
	DisplayText( 10, 7, lyrics->GetLine(current_line+1));
	DisplayText( 10, 8, lyrics->GetLine(current_line+2));
	break;
      case 2: // troisieme ligne active
	DisplayText( 10, 5, lyrics->GetLine(current_line+2));
	DisplayText( 10, 6, lyrics->GetLine(current_line+3));
	DisplayText( 10, 7, lyrics->GetLine(current_line));
	DisplayText( 10, 8, lyrics->GetLine(current_line+1));
	break;
      case 3: // quatrieme ligne active
	DisplayText( 10, 5, lyrics->GetLine(current_line+1));
	DisplayText( 10, 6, lyrics->GetLine(current_line+2));
	DisplayText( 10, 7, lyrics->GetLine(current_line-1));
	DisplayText( 10, 8, lyrics->GetLine(current_line));
	break;
     }
   
   refresh();
}

void Display_Ncurses::DisplayText( int x, int y, Midi_Lyric_Line *line)
{
   if ( line == NULL)
     return;
   
   char tmp[1024];//TODO
   
   int separation = line->GetSeparation( current_tick);
   
   if ( separation > 0)
     {
	strncpy( tmp, line->characters, separation);
	tmp[separation] = '\0';
	bkgdset( ' ' | COLOR_SELECTED) ;
	mvprintw( y, x, tmp);
     }
   if ( separation < line->nb_characters)
     {
	strcpy( tmp, line->characters+separation);
	bkgdset( ' ' | COLOR_NORMAL) ;
	mvprintw( y, x+separation, tmp);
     }
}
