#ifndef _DISPLAY_MANAGER_HPP
#define _DISPLAY_MANAGER_HPP

#include <SDL.h>
#include <SDL_thread.h>

class Display;
class Midi_Lyric;
class DisplayManager;
extern int LoopDisplay( void *display_manager);

class DisplayManager
{
 public:
   DisplayManager();
   ~DisplayManager();
  
   void Initialize( char *path_to_display_plugins);
   void Terminate();
   
   void LoadDisplayPlugin( char *plugin_name);

   void Update( unsigned int current_tick);
   
   void SetLyric( Midi_Lyric* lyric);

   
 private:
   void Loop();
   unsigned int WaitFrame( unsigned int fps);   
   
   Display *current_display;
   SDL_Thread *thread;
   SDL_mutex *mutex;
   int state;
   
   friend int LoopDisplay( void *);
};

#endif
