#ifndef _DISPLAY_HPP
#define _DISPLAY_HPP

#include <SDL_thread.h>

#define DYNAMIC_DISPLAY_SYMBOL   dynamic_display
#define DYNAMIC_DISPLAY_NAME   "dynamic_display"

class Midi_Lyric;
class Midi_Lyric_Line;
class Display;

extern Display *LoadDisplay( char *filename); 
extern void UnLoadDisplay( Display *display);

class Display
{
 public:
   enum State
     {
	UNINITIALIZED,
	WORKING,
	ERROR,  
     };
   
   Display();
   virtual ~Display();
   
   void Start();
   void Stop();
   void Update( unsigned int current_tick);
   void SetLyric( Midi_Lyric* lyric);
   virtual void Refresh( unsigned int dt);
   
 protected:
   virtual void Initialize();
   virtual void Terminate(); 
   State state;
   Midi_Lyric* lyrics;
   int lyrics_ready;
   unsigned int current_tick;
   
 private:
   void *handle; // conserve handle to close file TODO: should keep (in static data all the files open to avoid open x times the same plugin)
   friend Display *LoadDisplay( char*);
   friend void UnLoadDisplay( Display*);
};

#endif
