#include "display.hpp"
#include <stdlib.h>
#include <stdio.h>
#include <dlfcn.h>
#include <SDL.h>

Display::Display()
{
   state = UNINITIALIZED;
   lyrics_ready = 0;
}

Display::~Display()
{
   if ( state == WORKING)
     Stop();
}

void Display::Start()
{
   // 1) Init variables
   state = UNINITIALIZED;
   lyrics_ready = 0;
   
   // 2) Call plugin's Initialize method
   Initialize();
}

void Display::Stop()
{
   // Call plugin's Terminate method 
   Terminate();
}

void Display::Initialize()
{
}

void Display::Terminate()
{
}

void Display::Refresh( unsigned int dt)
{
}

void Display::SetLyric( Midi_Lyric* lyric)
{
   // taking this mutex can block the sequencer during refresh (in plugin)
   // but this is not critical because SetLuric is only called when
   // we load a new song or after the end.
   
   this->lyrics = lyric;
   if ( lyric != NULL)
     lyrics_ready = 1;
   else
     lyrics_ready = 0;
}

void Display::Update( unsigned int current_tick)
{
   this->current_tick = current_tick;
}

Display *LoadDisplay( char* filename)
{
   void *handle;
   Display *display;
   char *error;
  
   fprintf( stdout, "LoadDisplay: loading display %s\n", filename);
		      
   handle = dlopen( filename, RTLD_LAZY|RTLD_GLOBAL|RTLD_NOW);
   
   if ( handle == NULL)
     {
	fprintf( stderr, "LoadDisplay: %s\n", dlerror());
	return NULL;
     }
   
   display = (Display*) dlsym( handle, DYNAMIC_DISPLAY_NAME);
   
   if ( ( error = dlerror()) != NULL )
     {
	fprintf( stderr, "LoadDisplay: %s\n", error);
	dlclose( handle);
	return NULL;
     }
   
   display->handle = handle;
     
   return display;
}

void UnLoadDisplay( Display *display)
{
   void *handle = display->handle;  
   delete display;
   dlclose( handle);
}

