#ifndef _LIBDG100_H
#define _LIBDG100_H

#include <time.h>

typedef struct dg100 * dg100;

typedef struct dg100_waypoint dg100_waypoint;

typedef struct dg100_track dg100_track;

struct dg100_waypoint
{
   double latitude_deg;
   double longitude_deg;   
   struct tm datetime;   
};

struct dg100_track
{
   int index;
   struct tm datetime;
};

extern dg100 dg100_create( char *device);

extern void dg100_get_status( dg100 self);

extern void dg100_get_id( dg100 self);

extern void dg100_set_id( dg100 self);

extern void dg100_get_config( dg100 self);

extern void dg100_set_config( dg100 self);

extern void dg100_enter_gmouse_mode( dg100 self);

extern void dg100_leave_gmouse_mode( dg100 self);

extern void dg100_get_tracks_list( dg100 self);

extern void dg100_rewind_track( dg100 self);

extern dg100_track * dg100_get_next_track( dg100 self);

extern void dg100_get_track( dg100 self, unsigned short index);

extern void dg100_rewind_waypoint( dg100 self);

extern dg100_waypoint * dg100_get_next_waypoint( dg100 self);

extern void dg100_get_delete_tracks( dg100 self);

#endif
